/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.jdk.core.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;

abstract class HashCollectionGeneric<K, V, C extends Collection<V>>
implements Iterable<Map.Entry<K, C>> {
    private final Map<K, C> map;
    private Supplier<C> collectionSupplier;
    private final boolean isSynchronized;

    public HashCollectionGeneric(boolean isSynchronized, int initialCapacity, float loadFactor) {
        this.isSynchronized = isSynchronized;
        this.map = isSynchronized ? new ConcurrentHashMap<K, C>(initialCapacity, loadFactor) : new HashMap<K, C>(initialCapacity, loadFactor);
    }

    public C put(K key, V value) {
        Collection<Object> collection = (Collection)this.map.get(key);
        if (collection == null) {
            collection = this.createAndPutCollection(key);
        }
        collection.add(value);
        return (C)collection;
    }

    private C createAndPutCollection(K key) {
        Collection collection = (Collection)this.collectionSupplier.get();
        this.map.put(key, collection);
        return (C)collection;
    }

    public C put(K key, C values) {
        Collection items = null;
        if (values == null || values.isEmpty()) {
            if (!this.map.containsKey(key)) {
                this.createAndPutCollection(key);
            }
        } else {
            for (Object value : values) {
                if (items == null) {
                    items = this.put(key, (C)value);
                    continue;
                }
                items.add(value);
            }
        }
        return (C)items;
    }

    public boolean removeValue(K key, V value) {
        Collection collection = (Collection)this.map.get(key);
        if (collection != null && collection.remove(value)) {
            if (collection.isEmpty()) {
                this.map.remove(key);
            }
            return true;
        }
        return false;
    }

    public C removeValues(K key) {
        return (C)((Collection)this.map.remove(key));
    }

    public C getValues(K key) {
        return (C)((Collection)this.map.get(key));
    }

    public Collection<V> safeGetValues(K key) {
        ArrayList values = new ArrayList();
        this.forEachValue(key, values::add);
        return values;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachValue(K key, Consumer<V> consumer) {
        Collection collection = (Collection)this.map.get(key);
        if (collection == null) {
            return;
        }
        if (this.isSynchronized) {
            Collection collection2 = collection;
            synchronized (collection2) {
                collection.forEach(consumer);
            }
        } else {
            collection.forEach(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forEachValue(BiConsumer<K, V> consumer) {
        for (K key : this.map.keySet()) {
            Collection collection = (Collection)this.map.get(key);
            if (collection == null) continue;
            if (this.isSynchronized) {
                Collection collection2 = collection;
                synchronized (collection2) {
                    for (Object value : collection) {
                        consumer.accept(key, value);
                    }
                    continue;
                }
            }
            for (Object value : collection) {
                consumer.accept(key, value);
            }
        }
    }

    public List<V> getValues() {
        ArrayList values = new ArrayList();
        for (Collection objectPair : this.map.values()) {
            if (objectPair == null) continue;
            values.addAll(objectPair);
        }
        return values;
    }

    public Set<K> keySet() {
        return this.map.keySet();
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(K key) {
        return this.map.containsKey(key);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public Set<Map.Entry<K, C>> entrySet() {
        return this.map.entrySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        int size = 0;
        if (this.isSynchronized) {
            Map<K, C> map = this.map;
            synchronized (map) {
                for (K key : this.keySet()) {
                    size += this.getValues(key).size();
                }
            }
        } else {
            for (K key : this.keySet()) {
                size += this.getValues(key).size();
            }
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sizeByKey(K key) {
        int size = 0;
        if (this.isSynchronized) {
            Map<K, C> map = this.map;
            synchronized (map) {
                Collection values = (Collection)this.map.get(key);
                if (values != null) {
                    size = values.size();
                }
            }
        } else {
            Collection values = (Collection)this.map.get(key);
            if (values != null) {
                size = values.size();
            }
        }
        return size;
    }

    public boolean isSynchronized() {
        return this.isSynchronized;
    }

    public boolean containsValue(Object value) {
        for (Collection collection : this.map.values()) {
            if (!collection.contains(value)) continue;
            return true;
        }
        return false;
    }

    public void setCollectionSupplier(Supplier<C> collectionSupplier) {
        this.collectionSupplier = collectionSupplier;
    }

    @Override
    public Iterator<Map.Entry<K, C>> iterator() {
        return this.map.entrySet().iterator();
    }

    public String toString() {
        return this.map.toString();
    }
}

