/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.ICompareInput;
import org.eclipse.compare.structuremergeviewer.ICompareInputChangeListener;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.swt.graphics.Image;
import org.eclipse.team.internal.ui.mapping.CompareInputChangeNotifier;

public abstract class AbstractCompareInput
implements ICompareInput {
    private ITypedElement ancestor;
    private ITypedElement left;
    private ITypedElement right;
    private int kind;
    private final ListenerList listeners = new ListenerList(1);

    public AbstractCompareInput(int kind, ITypedElement ancestor, ITypedElement left, ITypedElement right) {
        this.kind = kind;
        this.ancestor = ancestor;
        this.left = left;
        this.right = right;
    }

    public void addCompareInputChangeListener(ICompareInputChangeListener listener) {
        if (!this.containsListener(listener)) {
            this.listeners.add((Object)listener);
            this.getChangeNotifier().connect(this);
        }
    }

    public void removeCompareInputChangeListener(ICompareInputChangeListener listener) {
        if (this.containsListener(listener)) {
            this.listeners.remove((Object)listener);
            this.getChangeNotifier().disconnect(this);
        }
    }

    protected void fireChange() {
        if (!this.listeners.isEmpty()) {
            Object[] allListeners;
            Object[] objectArray = allListeners = this.listeners.getListeners();
            int n = allListeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object l = objectArray[n2];
                final ICompareInputChangeListener listener = (ICompareInputChangeListener)l;
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        listener.compareInputChanged((ICompareInput)AbstractCompareInput.this);
                    }

                    public void handleException(Throwable exception) {
                    }
                });
                ++n2;
            }
        }
    }

    private boolean containsListener(ICompareInputChangeListener listener) {
        Object[] allListeners;
        if (this.listeners.isEmpty()) {
            return false;
        }
        Object[] objectArray = allListeners = this.listeners.getListeners();
        int n = allListeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object == listener) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public void copy(boolean leftToRight) {
        Assert.isTrue((boolean)false, (String)"Copy is not support by this type of compare input");
    }

    public ITypedElement getAncestor() {
        return this.ancestor;
    }

    public Image getImage() {
        return this.getMainElement().getImage();
    }

    private ITypedElement getMainElement() {
        if (this.left != null) {
            return this.left;
        }
        if (this.right != null) {
            return this.right;
        }
        return this.ancestor;
    }

    public int getKind() {
        return this.kind;
    }

    public void setKind(int kind) {
        this.kind = kind;
    }

    public ITypedElement getLeft() {
        return this.left;
    }

    public String getName() {
        return this.getMainElement().getName();
    }

    public ITypedElement getRight() {
        return this.right;
    }

    protected abstract CompareInputChangeNotifier getChangeNotifier();

    public void setAncestor(ITypedElement ancestor) {
        this.ancestor = ancestor;
    }

    public void setLeft(ITypedElement left) {
        this.left = left;
    }

    public void setRight(ITypedElement right) {
        this.right = right;
    }

    public abstract void update();

    public abstract boolean needsUpdate();
}

