/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.utility;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.osee.framework.jdk.core.result.XConsoleLogger;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.MatchFilter;

public class ConvertOseeTypesToRemoveGuid {
    public static void main(String[] args) {
        try {
            for (String dirNam : Arrays.asList("C:\\UserData\\git_fix\\org.eclipse.osee\\plugins\\", "C:\\UserData\\git_fix\\lba.osee\\plugins\\")) {
                File dir1 = new File(dirNam);
                for (String filename : Lib.readListFromDir((File)dir1, (FilenameFilter)new MatchFilter(".*"), (boolean)true)) {
                    if (!Strings.isValid((String)filename)) continue;
                    System.out.println(String.format("Processing [%s]", filename));
                    File file = new File(dir1 + "\\" + filename);
                    try {
                        ConvertOseeTypesToRemoveGuid.recurseAndFind(file);
                    }
                    catch (Exception ex) {
                        XConsoleLogger.err((String)ex.getLocalizedMessage(), (Object[])new Object[0]);
                    }
                }
            }
        }
        catch (Exception ex) {
            System.out.println(ex.getLocalizedMessage());
        }
    }

    private static void recurseAndFind(File file) throws IOException {
        try {
            if (file.isDirectory()) {
                for (String filename : Lib.readListFromDir((File)file, (FilenameFilter)new MatchFilter(".*"), (boolean)true)) {
                    File childFile = new File(String.valueOf(file.getAbsolutePath()) + "\\" + filename);
                    try {
                        ConvertOseeTypesToRemoveGuid.recurseAndFind(childFile);
                    }
                    catch (Exception ex) {
                        XConsoleLogger.err((String)ex.getLocalizedMessage(), (Object[])new Object[0]);
                    }
                }
            }
        }
        catch (Exception ex) {
            XConsoleLogger.err((String)ex.getLocalizedMessage(), (Object[])new Object[0]);
        }
        if (file.getAbsolutePath().endsWith(".osee")) {
            XConsoleLogger.err((String)("File " + file.getName()), (Object[])new Object[0]);
            String text = Lib.fileToString((File)file);
            text = text.replaceAll("guid +[0-9A-Za-z\\+_=]{20,22}", "");
            Lib.writeStringToFile((String)text, (File)file);
        }
    }
}

