/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.relation.order;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RelationOrderMerger<T> {
    private final List<T> starredList = new ArrayList<T>();

    public List<T> computeMergedOrder(List<T> leftOrder, List<T> rightOrder, Collection<T> mergedSet) {
        this.makeSubset(leftOrder, mergedSet);
        this.makeSubset(rightOrder, mergedSet);
        this.starUnionComplement(leftOrder, rightOrder);
        return this.cursorAlgorithm(leftOrder, rightOrder, mergedSet);
    }

    private void makeSubset(List<T> subset, Collection<T> superset) {
        int i = 0;
        while (i < subset.size()) {
            T current = subset.get(i);
            if (!superset.contains(current)) {
                subset.remove(i);
                --i;
            }
            ++i;
        }
    }

    private void starUnionComplement(Collection<T> left, Collection<T> right) {
        for (T element : left) {
            if (right.contains(element)) continue;
            this.addStar(element);
        }
        for (T element : right) {
            if (left.contains(element)) continue;
            this.addStar(element);
        }
    }

    private List<T> cursorAlgorithm(List<T> left, List<T> right, Collection<T> mergedSet) {
        T leftElement;
        ArrayList<T> mergedOrder = new ArrayList<T>();
        int leftIndex = 0;
        int rightIndex = 0;
        while (leftIndex < left.size() && rightIndex < right.size()) {
            leftElement = left.get(leftIndex);
            T rightElement = right.get(rightIndex);
            boolean resolved = false;
            if (leftElement.equals(rightElement)) {
                mergedOrder.add(leftElement);
                ++leftIndex;
                ++rightIndex;
                resolved = true;
            }
            if (this.hasStar(leftElement)) {
                mergedOrder.add(leftElement);
                ++leftIndex;
                resolved = true;
            }
            if (this.hasStar(rightElement)) {
                mergedOrder.add(rightElement);
                ++rightIndex;
                resolved = true;
            }
            if (resolved) continue;
            return null;
        }
        while (leftIndex < left.size()) {
            leftElement = left.get(leftIndex);
            mergedOrder.add(leftElement);
            ++leftIndex;
        }
        while (rightIndex < right.size()) {
            T rightElement = right.get(rightIndex);
            mergedOrder.add(rightElement);
            ++rightIndex;
        }
        return mergedOrder;
    }

    private void addStar(T element) {
        this.starredList.add(element);
    }

    private boolean hasStar(T element) {
        return this.starredList.contains(element);
    }
}

