/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.internal.event.handlers;

import java.util.List;
import org.eclipse.osee.framework.core.event.EventUtil;
import org.eclipse.osee.framework.messaging.event.res.RemoteEvent;
import org.eclipse.osee.framework.skynet.core.event.FrameworkEventUtil;
import org.eclipse.osee.framework.skynet.core.event.filter.IEventFilter;
import org.eclipse.osee.framework.skynet.core.event.listener.IArtifactEventListener;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.Sender;
import org.eclipse.osee.framework.skynet.core.internal.event.EventHandlerLocal;
import org.eclipse.osee.framework.skynet.core.internal.event.Transport;

public class ArtifactEventHandler
implements EventHandlerLocal<IArtifactEventListener, ArtifactEvent> {
    @Override
    public void handle(IArtifactEventListener listener, Sender sender, ArtifactEvent event) {
        EventUtil.eventLog((String)String.format("IEM: processArtsAndRels [%s]", event), (Object[])new Object[0]);
        List<? extends IEventFilter> filters = listener.getEventFilters();
        if (filters != null) {
            for (IEventFilter iEventFilter : filters) {
                if (!iEventFilter.isMatch(event.getBranch())) {
                    return;
                }
                if (event.getArtifacts().isEmpty() && event.getRelations().isEmpty()) continue;
                boolean matchFound = false;
                if (!event.getArtifacts().isEmpty() && iEventFilter.isMatchArtifacts(event.getArtifacts())) {
                    matchFound = true;
                }
                if (!matchFound && !event.getRelations().isEmpty() && iEventFilter.isMatchRelationArtifacts(event.getRelations())) {
                    matchFound = true;
                }
                if (matchFound) continue;
                return;
            }
        }
        listener.handleArtifactEvent(event, sender);
    }

    @Override
    public void send(Transport transport, Sender sender, ArtifactEvent event) {
        if (transport.isDispatchToLocalAllowed(sender)) {
            transport.sendLocal(sender, event);
        }
        if (sender.isLocal() && !event.isReloadEvent()) {
            transport.sendRemote((RemoteEvent)FrameworkEventUtil.getRemotePersistEvent(event));
        }
    }
}

