/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.importing.parsers;

import java.io.File;
import java.io.FileFilter;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.operation.OperationLogger;
import org.eclipse.osee.framework.jdk.core.type.DoubleKeyHashMap;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.util.GUID;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelSaxHandler;
import org.eclipse.osee.framework.jdk.core.util.io.xml.RowProcessor;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.importing.RoughArtifact;
import org.eclipse.osee.framework.skynet.core.importing.RoughRelation;
import org.eclipse.osee.framework.skynet.core.importing.operations.RoughArtifactCollector;
import org.eclipse.osee.framework.skynet.core.importing.parsers.AbstractArtifactExtractor;
import org.eclipse.osee.framework.skynet.core.internal.Activator;
import org.eclipse.osee.framework.skynet.core.internal.ServiceUtil;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class ExcelArtifactExtractor
extends AbstractArtifactExtractor {
    private static final Pattern guidPattern = Pattern.compile("(\\d*);(.*)");

    @Override
    public String getDescription() {
        return "Extract each row as an artifact, with header format <Attribute Type 1, Attribute Type 2, ...>";
    }

    @Override
    public FileFilter getFileFilter() {
        return new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.isFile() && file.getName().endsWith(".xml");
            }
        };
    }

    @Override
    public String getName() {
        return "Excel XML Artifacts";
    }

    @Override
    protected void extractFromSource(OperationLogger logger, URI source, RoughArtifactCollector collector) throws Exception {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        xmlReader.setContentHandler((ContentHandler)new ExcelSaxHandler((RowProcessor)new ExcelRowProcessor(collector), true));
        xmlReader.parse(new InputSource(new InputStreamReader(source.toURL().openStream(), "UTF-8")));
    }

    static /* synthetic */ Pattern access$0() {
        return guidPattern;
    }

    private static final class ExcelRowProcessor
    implements RowProcessor {
        private final DoubleKeyHashMap<String, Integer, RoughArtifact> relationHelper = new DoubleKeyHashMap();
        private final Map<Integer, RowTypeEnum> rowIndexToRowTypeMap = new HashMap<Integer, RowTypeEnum>();
        private final Matcher guidMatcher = ExcelArtifactExtractor.access$0().matcher("");
        private final RoughArtifactCollector collector;
        private int rowCount;
        private String[] headerRow;
        private ArtifactTypeToken primaryDescriptor;
        private boolean importingRelations;

        public ExcelRowProcessor(RoughArtifactCollector collector) {
            this.collector = collector;
            this.rowCount = 0;
            this.importingRelations = false;
        }

        public void detectedRowAndColumnCounts(int rowCount, int columnCount) {
        }

        public void foundStartOfWorksheet(String sheetName) {
            this.rowCount = 0;
            if (sheetName.equals("relations")) {
                this.importingRelations = true;
                return;
            }
            this.primaryDescriptor = ServiceUtil.getOrcsTokenService().getArtifactType(sheetName);
            if (this.primaryDescriptor == null) {
                throw new OseeArgumentException("The sheet [%s] is not a valid artifact type name.", new Object[]{sheetName});
            }
        }

        public void processCommentRow(String[] row) {
            ++this.rowCount;
        }

        public void processEmptyRow() {
            ++this.rowCount;
        }

        public void processHeaderRow(String[] headerRow) {
            ++this.rowCount;
            this.headerRow = (String[])headerRow.clone();
            int i = 0;
            while (i < this.headerRow.length) {
                String value = headerRow[i];
                if (value != null) {
                    value = value.trim();
                }
                if (!Strings.isValid((String)value)) {
                    this.headerRow[i] = null;
                } else {
                    RowTypeEnum rowTypeEnum = RowTypeEnum.fromString(value);
                    this.rowIndexToRowTypeMap.put(i, rowTypeEnum);
                }
                ++i;
            }
        }

        public void processRow(String[] row) {
            ++this.rowCount;
            if (this.importingRelations) {
                String guida = null;
                String guidb = null;
                guida = this.getGuid(row[1]);
                guidb = this.getGuid(row[2]);
                if (guida == null || guidb == null) {
                    OseeLog.log(Activator.class, (Level)Level.WARNING, (String)"we failed to add a relation because at least on of its guids are null");
                }
                this.collector.addRoughRelation(new RoughRelation(row[0], guida, guidb, row[5]));
            } else {
                RoughArtifact roughArtifact = new RoughArtifact(this.primaryDescriptor);
                if (!this.rowIndexToRowTypeMap.isEmpty()) {
                    int rowIndex = 0;
                    while (rowIndex < row.length) {
                        RowTypeEnum rowType = this.rowIndexToRowTypeMap.get(rowIndex);
                        String rowValue = row[rowIndex];
                        if (Strings.isValid((String)rowValue)) {
                            switch (rowType) {
                                case PARAGRAPH_NO: {
                                    roughArtifact.setSectionNumber(rowValue);
                                    roughArtifact.addAttribute((AttributeTypeToken)CoreAttributeTypes.ParagraphNumber, rowValue);
                                    break;
                                }
                                case ARTIFACT_NAME: {
                                    roughArtifact.setName(rowValue);
                                    break;
                                }
                                case GUID: {
                                    roughArtifact.setGuid(rowValue);
                                    break;
                                }
                                case OTHER: {
                                    roughArtifact.addAttribute(this.headerRow[rowIndex], rowValue);
                                }
                            }
                        } else if (rowType == RowTypeEnum.PARAGRAPH_NO) {
                            throw new OseeArgumentException("%s must not be blank", new Object[]{CoreAttributeTypes.ParagraphNumber});
                        }
                        ++rowIndex;
                    }
                }
                this.collector.addRoughArtifact(roughArtifact);
                this.relationHelper.put((Object)this.primaryDescriptor.getName(), (Object)this.rowCount, (Object)roughArtifact);
            }
        }

        private String getGuid(String string) {
            if (GUID.isValid((String)string)) {
                return string;
            }
            this.guidMatcher.reset(string);
            if (this.guidMatcher.matches()) {
                Integer row = Integer.parseInt(this.guidMatcher.group(1));
                String sheet = this.guidMatcher.group(2);
                RoughArtifact artifact = (RoughArtifact)this.relationHelper.get((Object)sheet, (Object)row);
                return artifact.getGuid();
            }
            return null;
        }

        public void reachedEndOfWorksheet() {
        }

        private static enum RowTypeEnum {
            PARAGRAPH_NO(CoreAttributeTypes.ParagraphNumber.getName()),
            ARTIFACT_NAME(CoreAttributeTypes.Name.getName()),
            GUID("GUID"),
            OTHER("");

            private static final Map<String, RowTypeEnum> rawStringToRowType;
            public String _rowType;

            static {
                rawStringToRowType = new HashMap<String, RowTypeEnum>();
            }

            private RowTypeEnum(String rowType) {
                this._rowType = rowType;
            }

            public static synchronized RowTypeEnum fromString(String value) {
                RowTypeEnum returnVal;
                if (rawStringToRowType.isEmpty()) {
                    RowTypeEnum[] rowTypeEnumArray = RowTypeEnum.values();
                    int n = rowTypeEnumArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        RowTypeEnum enumStatus = rowTypeEnumArray[n2];
                        rawStringToRowType.put(enumStatus._rowType, enumStatus);
                        ++n2;
                    }
                }
                return (returnVal = rawStringToRowType.get(value)) != null ? returnVal : OTHER;
            }
        }
    }
}

