/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.skynet.core.conflict;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.core.data.TransactionToken;
import org.eclipse.osee.framework.core.enums.ConflictStatus;
import org.eclipse.osee.framework.skynet.core.artifact.BranchManager;
import org.eclipse.osee.framework.skynet.core.conflict.Conflict;
import org.eclipse.osee.framework.skynet.core.revision.ConflictManagerInternal;

public class ConflictManagerExternal {
    private static final IProgressMonitor monitor = new NullProgressMonitor();
    private final BranchToken destinationBranch;
    private final BranchToken sourceBranch;
    private List<Conflict> originalConflicts;

    public ConflictManagerExternal(BranchId destinationBranch, BranchId sourceBranch) {
        this.destinationBranch = BranchManager.getBranchToken(destinationBranch);
        this.sourceBranch = BranchManager.getBranchToken(sourceBranch);
    }

    public List<Conflict> getOriginalConflicts() {
        if (this.originalConflicts == null) {
            this.originalConflicts = ConflictManagerInternal.getConflictsPerBranch(this.sourceBranch, this.destinationBranch, (TransactionToken)BranchManager.getBaseTransaction((BranchId)this.sourceBranch), monitor);
        }
        return this.originalConflicts;
    }

    public boolean originalConflictsExist() {
        return !this.getOriginalConflicts().isEmpty();
    }

    public List<Conflict> getRemainingConflicts() {
        ArrayList<Conflict> remainingConflicts = new ArrayList<Conflict>();
        for (Conflict conflict : this.getOriginalConflicts()) {
            ConflictStatus status = conflict.getStatus();
            if (status.isResolved() || status.isCommitted() || status.isInformational()) continue;
            remainingConflicts.add(conflict);
        }
        return remainingConflicts;
    }

    public boolean remainingConflictsExist() {
        return !this.getRemainingConflicts().isEmpty();
    }

    public BranchToken getDestinationBranch() {
        return this.destinationBranch;
    }

    public BranchToken getSourceBranch() {
        return this.sourceBranch;
    }
}

