/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.genericeditor.target.extension.autocomplete;

import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension6;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class TargetCompletionProposal
implements ICompletionProposal,
ICompletionProposalExtension6 {
    private StyledString fDisplayString;
    private String fReplacementString;
    private int fReplacementOffset;
    private int fReplacementLength;
    private int fCursorPosition;

    public TargetCompletionProposal(String replacementString, int cursorPosition, int replacementOffset, int replacementLength, StyledString displayString) {
        Assert.isNotNull((Object)replacementString);
        Assert.isTrue((cursorPosition >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementOffset >= 0 ? 1 : 0) != 0);
        Assert.isTrue((replacementLength >= 0 ? 1 : 0) != 0);
        Assert.isNotNull((Object)displayString);
        this.fReplacementString = replacementString;
        this.fCursorPosition = cursorPosition;
        this.fReplacementOffset = replacementOffset;
        this.fReplacementLength = replacementLength;
        this.fDisplayString = displayString;
    }

    public StyledString getStyledDisplayString() {
        return this.fDisplayString;
    }

    public void apply(IDocument document) {
        try {
            document.replace(this.fReplacementOffset, this.fReplacementLength, this.fReplacementString);
        }
        catch (BadLocationException badLocationException) {}
    }

    public Point getSelection(IDocument document) {
        return new Point(this.fReplacementOffset + this.fCursorPosition, 0);
    }

    public String getAdditionalProposalInfo() {
        return null;
    }

    public String getDisplayString() {
        return this.fDisplayString.toString();
    }

    public Image getImage() {
        return null;
    }

    public IContextInformation getContextInformation() {
        return null;
    }
}

