/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.branch.graph.parts;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.SelectionEditPolicy;
import org.eclipse.osee.framework.ui.branch.graph.model.BranchModel;
import org.eclipse.osee.framework.ui.branch.graph.model.TxModel;
import org.eclipse.osee.framework.ui.branch.graph.parts.GraphEditPart;

public class BranchEditPart
extends AbstractGraphicalEditPart {
    protected IFigure createFigure() {
        BranchModel branchModel = (BranchModel)this.getModel();
        GraphEditPart gPart = (GraphEditPart)this.getParent();
        Figure txContainer = new Figure();
        txContainer.setBackgroundColor(ColorConstants.white);
        txContainer.setOpaque(true);
        XYLayout layout = new XYLayout();
        txContainer.setLayoutManager((LayoutManager)layout);
        int height = branchModel.areTxsVisible() ? -1 : 30;
        Point point = this.getBranchFigureLocation(branchModel, gPart);
        Rectangle rect = new Rectangle(point.x, point.y, 220, height);
        IFigure parentFigure = gPart.getFigure();
        parentFigure.getLayoutManager().setConstraint((IFigure)txContainer, (Object)rect);
        return txContainer;
    }

    protected List getModelChildren() {
        ArrayList<Object> toReturn = new ArrayList<Object>();
        BranchModel model = (BranchModel)this.getModel();
        toReturn.add(model.getBranch());
        if (model.areTxsVisible()) {
            int index = 0;
            for (TxModel node : model.getTxs()) {
                node.setIndex(index++);
                toReturn.add(node);
            }
        }
        return toReturn;
    }

    private Point getBranchFigureLocation(BranchModel branchModel, GraphEditPart gPart) {
        int graphLevel = branchModel.getDepth();
        int branchesAboveLevel = 0;
        int index = 0;
        while (index < graphLevel) {
            branchesAboveLevel += gPart.getNumberOfBranchesAtGraphLevel(index);
            ++index;
        }
        int branchAtLevel = gPart.getNumberOfBranchesAtGraphLevel(graphLevel);
        int maxBranches = gPart.getMaxNumberOfBranchesAtAnyLevel();
        int xMiddle = maxBranches * 240 / 2;
        int xStart = xMiddle + (branchAtLevel - 1) * 240 / 2 * -1;
        xStart += 10 + (branchModel.getIndex() - branchesAboveLevel) * 240;
        int totalTxs = 0;
        int index2 = 0;
        while (index2 < graphLevel) {
            totalTxs += gPart.getMaxTxForGraphLevel(index2);
            ++index2;
        }
        int yStart = 10 + 50 * graphLevel + 50 * totalTxs;
        return new Point(xStart, yStart);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Selection Feedback", (EditPolicy)new SelectionEditPolicy(){

            protected void hideSelection() {
                BranchEditPart.this.refreshVisuals();
            }

            protected void showSelection() {
                BranchEditPart.this.refreshVisuals();
            }
        });
    }
}

