/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.data.model.editor;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.logging.Level;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.impl.URIHandlerImpl;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.io.StringOutputStream;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;

public class ArtifactURIHandler
extends URIHandlerImpl {
    private final String txComment;

    public ArtifactURIHandler(String txComment) {
        this.txComment = txComment;
    }

    public boolean canHandle(URI uri) {
        return "osee".equals(uri.scheme());
    }

    public InputStream createInputStream(URI uri, Map<?, ?> options) {
        return this.createStream(uri, this::createInputStream);
    }

    private InputStream createInputStream(Artifact artifact, Long attributeId) {
        try {
            Object value = artifact.getAttributeById(attributeId.longValue(), false).getValue();
            return Lib.stringToInputStream((String)value.toString());
        }
        catch (UnsupportedEncodingException ex) {
            OseeLog.log(ArtifactURIHandler.class, (Level)Level.SEVERE, (Throwable)ex);
            throw OseeCoreException.wrap((Throwable)ex);
        }
    }

    private <T> T createStream(URI uri, BiFunction<Artifact, Long, T> function) {
        String[] segments = uri.segments();
        BranchId branch = BranchId.valueOf((String)segments[0]);
        Artifact artifact = ArtifactQuery.getArtifactFromId((long)Long.parseLong(segments[2]), (BranchId)branch);
        Long attributeId = Long.parseLong(segments[4]);
        return function.apply(artifact, attributeId);
    }

    public boolean exists(URI uri, Map<?, ?> options) {
        return true;
    }

    public OutputStream createOutputStream(URI uri, Map<?, ?> options) {
        return this.createStream(uri, this::createOutputStream);
    }

    private OutputStream createOutputStream(Artifact artifact, Long attributeId) {
        return new StringOutputStream(value -> {
            artifact.setSoleAttributeFromString((AttributeTypeId)CoreAttributeTypes.GraphitiDiagram, value);
            artifact.persist(this.txComment);
        });
    }

    public Map<String, ?> getAttributes(URI uri, Map<?, ?> options) {
        HashMap<String, Boolean> result = new HashMap<String, Boolean>();
        Set requestedAttributes = this.getRequestedAttributes(options);
        if (requestedAttributes == null || requestedAttributes.contains("readOnly")) {
            result.put("readOnly", false);
        }
        return result;
    }
}

