/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.util.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.nebula.widgets.xviewer.util.XViewerDisplay;
import org.eclipse.nebula.widgets.xviewer.util.internal.PatternFilter;
import org.eclipse.nebula.widgets.xviewer.util.internal.XViewerWorkbenchJob;
import org.eclipse.nebula.widgets.xviewer.util.internal.images.XViewerImageCache;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class FilteredTreeComposite
extends Composite {
    protected Text filterText;
    protected ToolBarManager filterToolBar;
    protected TreeViewer treeViewer;
    protected Composite filterComposite;
    private PatternFilter patternFilter;
    protected String initialText = "";
    private XViewerWorkbenchJob refreshJob;
    protected Composite parent;
    protected boolean showFilterControls;
    protected Composite treeComposite;
    private static final String CLEAR_ICON = "org.eclipse.ui.internal.dialogs.CLEAR_ICON";
    private static final String DCLEAR_ICON = "org.eclipse.ui.internal.dialogs.DCLEAR_ICON";
    private static final long SOFT_MAX_EXPAND_TIME = 200L;
    private String previousFilterText;
    private boolean narrowingDown;

    static {
        ImageDescriptor descriptor = null;
        if (!XViewerDisplay.isStandaloneXViewer().booleanValue() && XViewerDisplay.isWorkbenchRunning()) {
            descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"$nl$/icons/full/etool16/clear_co.gif");
            if (descriptor != null) {
                JFaceResources.getImageRegistry().put(CLEAR_ICON, descriptor);
            }
            descriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.ui", (String)"$nl$/icons/full/dtool16/clear_co.gif");
        }
        if (descriptor != null) {
            JFaceResources.getImageRegistry().put(DCLEAR_ICON, descriptor);
        }
    }

    public FilteredTreeComposite(Composite parent, int treeStyle, PatternFilter filter) {
        super(parent, 0);
        this.parent = parent;
        this.init(treeStyle, filter);
    }

    protected FilteredTreeComposite(Composite parent) {
        super(parent, 0);
        this.parent = parent;
    }

    protected void init(int treeStyle, PatternFilter filter) {
        this.patternFilter = filter;
        this.showFilterControls = true;
        if (!XViewerDisplay.isStandaloneXViewer().booleanValue() && XViewerDisplay.isWorkbenchRunning()) {
            this.showFilterControls = PlatformUI.getPreferenceStore().getBoolean("SHOW_FILTERED_TEXTS");
        }
        this.createControl(this.parent, treeStyle);
        this.createRefreshJob();
        this.setInitialText(WorkbenchMessages.FilteredTree_FilterMessage);
        this.setFont(this.parent.getFont());
    }

    protected void createControl(Composite parent, int treeStyle) {
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        if (this.showFilterControls) {
            this.filterComposite = new Composite((Composite)this, 0);
            GridLayout filterLayout = new GridLayout(2, false);
            filterLayout.marginHeight = 0;
            filterLayout.marginWidth = 0;
            this.filterComposite.setLayout((Layout)filterLayout);
            this.filterComposite.setFont(parent.getFont());
            this.createFilterControls(this.filterComposite);
            this.filterComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        }
        this.treeComposite = new Composite((Composite)this, 0);
        GridLayout treeCompositeLayout = new GridLayout();
        treeCompositeLayout.marginHeight = 0;
        treeCompositeLayout.marginWidth = 0;
        this.treeComposite.setLayout((Layout)treeCompositeLayout);
        GridData data = new GridData(4, 4, true, true);
        this.treeComposite.setLayoutData((Object)data);
        this.createTreeControl(this.treeComposite, treeStyle);
    }

    protected Composite createFilterControls(Composite parent) {
        this.createFilterText(parent);
        this.createClearText(parent);
        if (this.filterToolBar != null) {
            this.filterToolBar.update(false);
            this.filterToolBar.getControl().setVisible(false);
        }
        return parent;
    }

    protected Control createTreeControl(Composite parent, int style) {
        this.treeViewer = this.doCreateTreeViewer(parent, style);
        GridData data = new GridData(4, 4, true, true);
        this.treeViewer.getControl().setLayoutData((Object)data);
        this.treeViewer.getControl().addListener(12, e -> {
            boolean bl = this.refreshJob.cancel();
        });
        if (this.treeViewer instanceof NotifyingTreeViewer) {
            this.patternFilter.setUseCache(true);
        }
        this.treeViewer.addFilter((ViewerFilter)this.patternFilter);
        return this.treeViewer.getControl();
    }

    protected TreeViewer doCreateTreeViewer(Composite parent, int style) {
        return new NotifyingTreeViewer(parent, style);
    }

    private TreeItem getFirstMatchingItem(TreeItem[] items) {
        if (items.length > 0) {
            TreeItem treeItem = items[0];
            if (this.patternFilter.isLeafMatch((Viewer)this.treeViewer, treeItem.getData()) && this.patternFilter.isElementSelectable(treeItem.getData())) {
                return treeItem;
            }
            return this.getFirstMatchingItem(treeItem.getItems());
        }
        return null;
    }

    private void createRefreshJob() {
        this.refreshJob = this.doCreateRefreshJob();
        this.refreshJob.setSystem(true);
    }

    protected XViewerWorkbenchJob doCreateRefreshJob() {
        return new XViewerWorkbenchJob("Refresh Filter"){

            @Override
            public IStatus runInUIThread(IProgressMonitor monitor) {
                boolean initial;
                if (FilteredTreeComposite.this.treeViewer.getControl().isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                String text = FilteredTreeComposite.this.getFilterString();
                if (text == null) {
                    return Status.OK_STATUS;
                }
                boolean bl = initial = FilteredTreeComposite.this.initialText != null && FilteredTreeComposite.this.initialText.equals(text);
                if (initial) {
                    FilteredTreeComposite.this.patternFilter.setPattern(null);
                } else {
                    FilteredTreeComposite.this.patternFilter.setPattern(text);
                }
                Composite redrawFalseControl = FilteredTreeComposite.this.treeComposite != null ? FilteredTreeComposite.this.treeComposite : FilteredTreeComposite.this.treeViewer.getControl();
                try {
                    redrawFalseControl.setRedraw(false);
                    if (!FilteredTreeComposite.this.narrowingDown) {
                        TreeItem[] is = FilteredTreeComposite.this.treeViewer.getTree().getItems();
                        int i = 0;
                        while (i < is.length) {
                            TreeItem item = is[i];
                            if (item.getExpanded()) {
                                FilteredTreeComposite.this.treeViewer.setExpandedState(item.getData(), false);
                            }
                            ++i;
                        }
                    }
                    FilteredTreeComposite.this.treeViewer.refresh(true);
                    if (text.length() > 0 && !initial) {
                        TreeItem[] items = FilteredTreeComposite.this.getViewer().getTree().getItems();
                        int treeHeight = FilteredTreeComposite.this.getViewer().getTree().getBounds().height;
                        int numVisibleItems = treeHeight / FilteredTreeComposite.this.getViewer().getTree().getItemHeight();
                        long stopTime = 200L + System.currentTimeMillis();
                        boolean cancel = false;
                        if (items.length > 0 && this.recursiveExpand(items, monitor, stopTime, new int[]{numVisibleItems})) {
                            cancel = true;
                        }
                        FilteredTreeComposite.this.updateToolbar(true);
                        if (cancel) {
                            IStatus iStatus = Status.CANCEL_STATUS;
                            return iStatus;
                        }
                    } else {
                        FilteredTreeComposite.this.updateToolbar(false);
                    }
                }
                finally {
                    TreeItem[] items = FilteredTreeComposite.this.getViewer().getTree().getItems();
                    if (items.length > 0 && FilteredTreeComposite.this.getViewer().getTree().getSelectionCount() == 0) {
                        FilteredTreeComposite.this.treeViewer.getTree().setTopItem(items[0]);
                    }
                    redrawFalseControl.setRedraw(true);
                }
                return Status.OK_STATUS;
            }

            private boolean recursiveExpand(TreeItem[] items, IProgressMonitor monitor, long cancelTime, int[] numItemsLeft) {
                boolean canceled = false;
                int i = 0;
                while (!canceled && i < items.length) {
                    boolean visible;
                    TreeItem item = items[i];
                    int n = numItemsLeft[0];
                    numItemsLeft[0] = n - 1;
                    boolean bl = visible = n >= 0;
                    if (monitor.isCanceled() || !visible && System.currentTimeMillis() > cancelTime) {
                        canceled = true;
                    } else {
                        Object itemData = item.getData();
                        if (itemData != null) {
                            if (!item.getExpanded()) {
                                FilteredTreeComposite.this.treeViewer.setExpandedState(itemData, true);
                            }
                            TreeItem[] children = item.getItems();
                            if (items.length > 0) {
                                canceled = this.recursiveExpand(children, monitor, cancelTime, numItemsLeft);
                            }
                        }
                    }
                    ++i;
                }
                return canceled;
            }
        };
    }

    protected void updateToolbar(boolean visible) {
        if (this.filterToolBar != null) {
            this.filterToolBar.getControl().setVisible(visible);
        }
    }

    protected void createFilterText(Composite parent) {
        this.filterText = this.doCreateFilterText(parent);
        this.filterText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String filterTextString = FilteredTreeComposite.this.filterText.getText();
                e.result = filterTextString.length() == 0 || filterTextString.equals(FilteredTreeComposite.this.initialText) ? FilteredTreeComposite.this.initialText : NLS.bind((String)WorkbenchMessages.FilteredTree_AccessibleListenerFiltered, (Object[])new String[]{filterTextString, String.valueOf(this.getFilteredItemsCount())});
            }

            private int getFilteredItemsCount() {
                int total = 0;
                TreeItem[] items = FilteredTreeComposite.this.getViewer().getTree().getItems();
                int i = 0;
                while (i < items.length) {
                    total += this.itemCount(items[i]);
                    ++i;
                }
                return total;
            }

            private int itemCount(TreeItem treeItem) {
                int count = 1;
                TreeItem[] children = treeItem.getItems();
                int i = 0;
                while (i < children.length) {
                    count += this.itemCount(children[i]);
                    ++i;
                }
                return count;
            }
        });
        this.filterText.addListener(15, e -> {
            Display display = this.filterText.getDisplay();
            display.asyncExec(() -> {
                if (!this.filterText.isDisposed() && this.getInitialText().equals(this.filterText.getText().trim())) {
                    this.filterText.selectAll();
                }
            });
        });
        this.filterText.addListener(1, e -> {
            boolean hasItems;
            boolean bl = hasItems = this.getViewer().getTree().getItemCount() > 0;
            if (hasItems && e.keyCode == 0x1000002) {
                this.treeViewer.getTree().setFocus();
            } else if (e.character == '\r') {
                return;
            }
        });
        this.filterText.addListener(31, e -> {
            if (e.detail == 4) {
                e.doit = false;
                if (this.getViewer().getTree().getItemCount() == 0) {
                    Display.getCurrent().beep();
                } else {
                    TreeItem item;
                    boolean textChanged;
                    boolean hasFocus = this.getViewer().getTree().setFocus();
                    boolean bl = textChanged = !this.getInitialText().equals(this.filterText.getText().trim());
                    if (hasFocus && textChanged && this.filterText.getText().trim().length() > 0 && (item = this.getFirstMatchingItem(this.getViewer().getTree().getItems())) != null) {
                        this.getViewer().getTree().setSelection(new TreeItem[]{item});
                        ISelection sel = this.getViewer().getSelection();
                        this.getViewer().setSelection(sel, true);
                    }
                }
            }
        });
        this.filterText.addListener(24, e -> this.textChanged());
        if ((this.filterText.getStyle() & 0x100) != 0) {
            this.filterText.addListener(14, e -> {
                if (e.detail == 256) {
                    this.clearText();
                }
            });
        }
        GridData gridData = new GridData(4, 1, true, false);
        if ((this.filterText.getStyle() & 0x100) != 0) {
            gridData.horizontalSpan = 2;
        }
        this.filterText.setLayoutData((Object)gridData);
    }

    protected Text doCreateFilterText(Composite parent) {
        return new Text(parent, 2436);
    }

    protected void textChanged() {
        this.narrowingDown = this.previousFilterText == null || this.getFilterString().startsWith(this.previousFilterText);
        this.previousFilterText = this.getFilterString();
        if (XViewerDisplay.isStandaloneXViewer().booleanValue()) {
            this.refreshJob.run((IProgressMonitor)new NullProgressMonitor());
        } else {
            this.refreshJob.cancel();
            this.refreshJob.schedule(200L);
        }
    }

    public void setBackground(Color background) {
        super.setBackground(background);
        if (this.filterComposite != null) {
            this.filterComposite.setBackground(background);
        }
        if (this.filterToolBar != null && this.filterToolBar.getControl() != null) {
            this.filterToolBar.getControl().setBackground(background);
        }
    }

    private void createClearText(Composite parent) {
        if ((this.filterText.getStyle() & 0x100) == 0) {
            this.filterToolBar = new ToolBarManager(0x800100);
            this.filterToolBar.createControl(parent);
            Action clearTextAction = new Action("", 1){

                public void run() {
                    FilteredTreeComposite.this.clearText();
                }
            };
            clearTextAction.setToolTipText(WorkbenchMessages.FilteredTree_ClearToolTip);
            clearTextAction.setImageDescriptor(XViewerImageCache.getImageDescriptor("clear.gif"));
            clearTextAction.setDisabledImageDescriptor(JFaceResources.getImageRegistry().getDescriptor(DCLEAR_ICON));
            this.filterToolBar.add((IAction)clearTextAction);
        }
    }

    protected void clearText() {
        this.setFilterText("");
        this.textChanged();
    }

    protected void setFilterText(String string) {
        if (this.filterText != null) {
            this.filterText.setText(string);
            this.selectAll();
        }
    }

    public final PatternFilter getPatternFilter() {
        return this.patternFilter;
    }

    public TreeViewer getViewer() {
        return this.treeViewer;
    }

    public Text getFilterControl() {
        return this.filterText;
    }

    protected String getFilterString() {
        return this.filterText != null ? this.filterText.getText() : null;
    }

    public void setInitialText(String text) {
        this.initialText = text;
        this.setFilterText(this.initialText);
        this.textChanged();
    }

    protected void selectAll() {
        if (this.filterText != null) {
            this.filterText.selectAll();
        }
    }

    protected String getInitialText() {
        return this.initialText;
    }

    public static Font getBoldFont(Object element, FilteredTreeComposite tree, PatternFilter filter) {
        String filterText = tree.getFilterString();
        if (filterText == null) {
            return null;
        }
        String initialText = tree.getInitialText();
        if (!"".equals(filterText) && !initialText.equals(filterText)) {
            boolean initial = initialText.equals(filterText);
            if (initial) {
                filter.setPattern(null);
            } else {
                filter.setPattern(filterText);
            }
            if (filter.isElementVisible((Viewer)tree.getViewer(), element) && filter.isLeafMatch((Viewer)tree.getViewer(), element)) {
                return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont");
            }
        }
        return null;
    }

    class NotifyingTreeViewer
    extends TreeViewer {
        public NotifyingTreeViewer(Composite parent, int style) {
            super(parent, style);
        }

        public void add(Object parentElementOrTreePath, Object childElement) {
            FilteredTreeComposite.this.getPatternFilter().clearCaches();
            super.add(parentElementOrTreePath, childElement);
        }

        public void add(Object parentElementOrTreePath, Object[] childElements) {
            FilteredTreeComposite.this.getPatternFilter().clearCaches();
            super.add(parentElementOrTreePath, childElements);
        }

        protected void inputChanged(Object input, Object oldInput) {
            FilteredTreeComposite.this.getPatternFilter().clearCaches();
            super.inputChanged(input, oldInput);
        }

        public void insert(Object parentElementOrTreePath, Object element, int position) {
            FilteredTreeComposite.this.getPatternFilter().clearCaches();
            super.insert(parentElementOrTreePath, element, position);
        }

        public void refresh() {
            FilteredTreeComposite.this.getPatternFilter().clearCaches();
            super.refresh();
        }

        public void refresh(boolean updateLabels) {
            FilteredTreeComposite.this.getPatternFilter().clearCaches();
            super.refresh(updateLabels);
        }

        public void refresh(Object element) {
            FilteredTreeComposite.this.getPatternFilter().clearCaches();
            super.refresh(element);
        }

        public void refresh(Object element, boolean updateLabels) {
            FilteredTreeComposite.this.getPatternFilter().clearCaches();
            super.refresh(element, updateLabels);
        }

        public void remove(Object elementsOrTreePaths) {
            FilteredTreeComposite.this.getPatternFilter().clearCaches();
            super.remove(elementsOrTreePaths);
        }

        public void remove(Object parent, Object[] elements) {
            FilteredTreeComposite.this.getPatternFilter().clearCaches();
            super.remove(parent, elements);
        }

        public void remove(Object[] elementsOrTreePaths) {
            FilteredTreeComposite.this.getPatternFilter().clearCaches();
            super.remove(elementsOrTreePaths);
        }

        public void replace(Object parentElementOrTreePath, int index, Object element) {
            FilteredTreeComposite.this.getPatternFilter().clearCaches();
            super.replace(parentElementOrTreePath, index, element);
        }

        public void setChildCount(Object elementOrTreePath, int count) {
            FilteredTreeComposite.this.getPatternFilter().clearCaches();
            super.setChildCount(elementOrTreePath, count);
        }

        public void setContentProvider(IContentProvider provider) {
            FilteredTreeComposite.this.getPatternFilter().clearCaches();
            super.setContentProvider(provider);
        }

        public void setHasChildren(Object elementOrTreePath, boolean hasChildren) {
            FilteredTreeComposite.this.getPatternFilter().clearCaches();
            super.setHasChildren(elementOrTreePath, hasChildren);
        }
    }
}

