/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.widgets.xviewer.customize.dialog;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.nebula.widgets.xviewer.core.util.CollectionsUtil;
import org.eclipse.nebula.widgets.xviewer.customize.dialog.XViewerCustomizeDialog;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class XViewerCustDialogDragDrop {
    private final XViewerCustomizeDialog xViewerCustomizeDialog;
    DragSourceAdapter hiddenTableDragListener = new DragSourceAdapter(){

        public void dragStart(DragSourceEvent event) {
            if (((XViewerCustDialogDragDrop)XViewerCustDialogDragDrop.this).xViewerCustomizeDialog.hiddenColTable.getViewer().getSelection().isEmpty()) {
                event.doit = false;
            }
        }

        public void dragSetData(DragSourceEvent event) {
            if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                List<XViewerColumn> selCols = XViewerCustDialogDragDrop.this.xViewerCustomizeDialog.getHiddenTableSelection();
                ArrayList<String> ids = new ArrayList<String>(selCols.size());
                for (XViewerColumn xCol : selCols) {
                    ids.add(xCol.getId());
                }
                event.data = CollectionsUtil.toString(ids, null, (String)", ", null);
            }
        }
    };
    DropTargetAdapter hiddenTableDropListener = new DropTargetAdapter(){

        public void dragOperationChanged(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            if (event.data instanceof String) {
                XViewerCustDialogDragDrop.this.performHiddenTableTextDrop(event);
            }
        }

        public void dragOver(DropTargetEvent event) {
            XViewerCustDialogDragDrop.this.performHiddenTableDragOver(event);
        }

        public void dropAccept(DropTargetEvent event) {
        }
    };
    DragSourceAdapter visibleTableDragListener = new DragSourceAdapter(){

        public void dragStart(DragSourceEvent event) {
            if (((XViewerCustDialogDragDrop)XViewerCustDialogDragDrop.this).xViewerCustomizeDialog.visibleColTable.getViewer().getSelection().isEmpty()) {
                event.doit = false;
            }
        }

        public void dragSetData(DragSourceEvent event) {
            if (TextTransfer.getInstance().isSupportedType(event.dataType)) {
                List<XViewerColumn> selCols = XViewerCustDialogDragDrop.this.xViewerCustomizeDialog.getVisibleTableSelection();
                ArrayList<String> ids = new ArrayList<String>(selCols.size());
                for (XViewerColumn xCol : selCols) {
                    ids.add(xCol.getId());
                }
                event.data = CollectionsUtil.toString(ids, null, (String)", ", null);
            }
        }
    };
    DropTargetAdapter visibleTableDropListener = new DropTargetAdapter(){

        public void dragOperationChanged(DropTargetEvent event) {
        }

        public void drop(DropTargetEvent event) {
            if (event.data instanceof String) {
                XViewerCustDialogDragDrop.this.performVisibleTableTextDrop(event);
            }
        }

        public void dragOver(DropTargetEvent event) {
            XViewerCustDialogDragDrop.this.performVisibleTableDragOver(event);
        }

        public void dropAccept(DropTargetEvent event) {
        }
    };

    public XViewerCustDialogDragDrop(XViewerCustomizeDialog xViewerCustomizeDialog) {
        this.xViewerCustomizeDialog = xViewerCustomizeDialog;
        xViewerCustomizeDialog.visibleColTable.getViewer().addDragSupport(2, new Transfer[]{TextTransfer.getInstance()}, (DragSourceListener)this.visibleTableDragListener);
        xViewerCustomizeDialog.visibleColTable.getViewer().addDropSupport(2, new Transfer[]{TextTransfer.getInstance()}, (DropTargetListener)this.visibleTableDropListener);
        xViewerCustomizeDialog.hiddenColTable.getViewer().addDragSupport(2, new Transfer[]{TextTransfer.getInstance()}, (DragSourceListener)this.hiddenTableDragListener);
        xViewerCustomizeDialog.hiddenColTable.getViewer().addDropSupport(2, new Transfer[]{TextTransfer.getInstance()}, (DropTargetListener)this.hiddenTableDropListener);
    }

    public void performHiddenTableDragOver(DropTargetEvent event) {
        if (!TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
            event.detail = 0;
            return;
        }
        if (event.widget != this.xViewerCustomizeDialog.visibleColTable) {
            return;
        }
        event.detail = 2;
    }

    public void performHiddenTableTextDrop(DropTargetEvent event) {
        String droppedIds = (String)event.data;
        ArrayList<XViewerColumn> droppedVisibleTableXCols = new ArrayList<XViewerColumn>();
        List orderCols = (List)this.xViewerCustomizeDialog.visibleColTable.getViewer().getInput();
        for (XViewerColumn xCol : orderCols) {
            if (!droppedIds.contains(xCol.getId())) continue;
            droppedVisibleTableXCols.add(xCol);
        }
        this.xViewerCustomizeDialog.moveFromVisibleToHidden(droppedVisibleTableXCols);
    }

    public void performVisibleTableTextDrop(DropTargetEvent event) {
        Tree tree = this.xViewerCustomizeDialog.visibleColTable.getViewer().getTree();
        TreeItem dragOverTreeItem = tree.getItem(this.xViewerCustomizeDialog.visibleColTable.getViewer().getTree().toControl(event.x, event.y));
        String droppedIds = (String)event.data;
        XViewerColumn dragOverXCol = null;
        if (dragOverTreeItem != null && droppedIds.contains((dragOverXCol = (XViewerColumn)dragOverTreeItem.getData()).getId())) {
            return;
        }
        ArrayList<XViewerColumn> droppedXCols = new ArrayList<XViewerColumn>();
        List orderCols = (List)this.xViewerCustomizeDialog.visibleColTable.getViewer().getInput();
        for (XViewerColumn xCol : orderCols) {
            if (!droppedIds.contains(xCol.getId())) continue;
            droppedXCols.add(xCol);
        }
        for (XViewerColumn xCol : (List)this.xViewerCustomizeDialog.hiddenColTable.getViewer().getInput()) {
            if (!droppedIds.contains(xCol.getId())) continue;
            droppedXCols.add(xCol);
        }
        orderCols.removeAll(droppedXCols);
        int dropXColOrderColsIndex = 0;
        for (XViewerColumn xCol : (List)this.xViewerCustomizeDialog.visibleColTable.getViewer().getInput()) {
            if (dragOverXCol != null && xCol.getId().equals(dragOverXCol.getId())) break;
            ++dropXColOrderColsIndex;
        }
        if (this.xViewerCustomizeDialog.isFeedbackAfter) {
            orderCols.addAll(dropXColOrderColsIndex + 1, droppedXCols);
        } else {
            orderCols.addAll(dropXColOrderColsIndex, droppedXCols);
        }
        this.xViewerCustomizeDialog.visibleColTable.getViewer().setInput((Object)orderCols);
        List hiddenCols = (List)this.xViewerCustomizeDialog.hiddenColTable.getViewer().getInput();
        hiddenCols.removeAll(droppedXCols);
        this.xViewerCustomizeDialog.hiddenColTable.getViewer().setInput((Object)hiddenCols);
    }

    public void performVisibleTableDragOver(DropTargetEvent event) {
        if (!TextTransfer.getInstance().isSupportedType(event.currentDataType)) {
            event.detail = 0;
            return;
        }
        Tree tree = this.xViewerCustomizeDialog.visibleColTable.getViewer().getTree();
        TreeItem dragOverTreeItem = tree.getItem(this.xViewerCustomizeDialog.visibleColTable.getViewer().getTree().toControl(event.x, event.y));
        if (dragOverTreeItem == null) {
            return;
        }
        event.feedback = 16;
        event.detail = 0;
        IStructuredSelection selectedItem = (IStructuredSelection)this.xViewerCustomizeDialog.visibleColTable.getViewer().getSelection();
        if (selectedItem == null || selectedItem.isEmpty()) {
            selectedItem = (IStructuredSelection)this.xViewerCustomizeDialog.hiddenColTable.getViewer().getSelection();
        }
        if (selectedItem == null) {
            return;
        }
        Object obj = selectedItem.getFirstElement();
        if (obj instanceof XViewerColumn) {
            event.feedback = this.xViewerCustomizeDialog.isFeedbackAfter ? 4 : 2;
            event.detail = 2;
        }
    }
}

