/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.world.search;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.query.IAtsWorkItemFilter;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.core.util.AtsObjects;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.world.search.AttributeValueQuickSearch;
import org.eclipse.osee.ats.ide.world.search.LegacyPcrIdQuickSearch;
import org.eclipse.osee.ats.ide.world.search.TeamDefinitionQuickSearch;
import org.eclipse.osee.ats.ide.world.search.WorldSearchItem;
import org.eclipse.osee.ats.ide.world.search.WorldUISearchItem;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;

public class LegacyPCRActionsWorldSearchItem
extends WorldUISearchItem {
    private final boolean returnActions;
    private final Collection<String> pcrIds;
    private final Collection<IAtsTeamDefinition> teamDefs;

    public LegacyPCRActionsWorldSearchItem(Collection<String> pcrIds, Collection<IAtsTeamDefinition> teamDefs, boolean returnActions) {
        super("");
        this.pcrIds = pcrIds;
        this.teamDefs = teamDefs;
        this.returnActions = returnActions;
    }

    public LegacyPCRActionsWorldSearchItem(LegacyPCRActionsWorldSearchItem legacyPCRActionsWorldSearchItem) {
        super(legacyPCRActionsWorldSearchItem);
        this.returnActions = legacyPCRActionsWorldSearchItem.returnActions;
        this.pcrIds = legacyPCRActionsWorldSearchItem.pcrIds;
        this.teamDefs = legacyPCRActionsWorldSearchItem.teamDefs;
    }

    private boolean isPcrIdsSet() {
        return this.pcrIds != null && !this.pcrIds.isEmpty();
    }

    private boolean isTeamDefsSet() {
        return this.teamDefs != null && !this.teamDefs.isEmpty();
    }

    @Override
    public Collection<Artifact> performSearch(WorldSearchItem.SearchType searchType) {
        AttributeValueQuickSearch srch;
        ArrayList<Artifact> pcrIdArts = new ArrayList<Artifact>();
        ArrayList<Artifact> teamDefArts = new ArrayList<Artifact>();
        List teamDefIds = new ArrayList();
        if (this.isPcrIdsSet()) {
            srch = new LegacyPcrIdQuickSearch(this.pcrIds);
            pcrIdArts.addAll(srch.performSearch());
        }
        if (this.isTeamDefsSet()) {
            srch = new TeamDefinitionQuickSearch(this.teamDefs);
            teamDefArts.addAll(((TeamDefinitionQuickSearch)srch).performSearch());
            teamDefIds = AtsObjects.toIds(this.teamDefs);
        }
        ArrayList<Artifact> arts = new ArrayList<Artifact>();
        if (this.isPcrIdsSet() && this.isTeamDefsSet()) {
            arts = Collections.setIntersection(pcrIdArts, teamDefArts);
        } else if (this.isPcrIdsSet()) {
            arts = pcrIdArts;
        } else if (this.isTeamDefsSet()) {
            arts = teamDefArts;
        }
        ArrayList<IAtsWorkItem> workItems = new ArrayList<IAtsWorkItem>();
        for (Artifact art : arts) {
            workItems.add((IAtsWorkItem)art);
        }
        IAtsWorkItemFilter filter = AtsApiService.get().getQueryService().createFilter(workItems).withOrValue((AttributeTypeToken)AtsAttributeTypes.LegacyPcrId, this.pcrIds).withOrValue((AttributeTypeToken)AtsAttributeTypes.TeamDefinitionReference, teamDefIds).isOfType(new ArtifactTypeToken[]{AtsArtifactTypes.TeamWorkflow});
        ArrayList<Artifact> results = new ArrayList<Artifact>();
        if (this.returnActions) {
            for (IAtsWorkItem workItem : filter.getItems()) {
                results.add((Artifact)((AbstractWorkflowArtifact)workItem.getStoreObject()).getParentAction().getStoreObject());
            }
        } else {
            for (IAtsWorkItem workItem : filter.getItems()) {
                results.add((AbstractWorkflowArtifact)workItem.getStoreObject());
            }
        }
        return results;
    }

    @Override
    public WorldUISearchItem copy() {
        return new LegacyPCRActionsWorldSearchItem(this);
    }
}

