/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.transition;

import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workflow.transition.ITransitionHelper;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResult;
import org.eclipse.osee.ats.api.workflow.transition.TransitionResults;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLog;

public class TransitionToOperation
extends AbstractOperation {
    private final ITransitionHelper helper;
    private TransitionResults results;

    public TransitionToOperation(ITransitionHelper helper) {
        super(helper.getName(), "org.eclipse.osee.ats.ide");
        this.helper = helper;
    }

    protected void doWork(IProgressMonitor monitor) throws Exception {
        try {
            IAtsChangeSet changes = AtsApiService.get().createChangeSet(String.valueOf(this.helper.getName()) + ".preSave");
            for (IAtsWorkItem workItem : this.helper.getWorkItems()) {
                AbstractWorkflowArtifact awa = (AbstractWorkflowArtifact)workItem;
                if (!awa.isDirty()) continue;
                changes.add((Object)awa);
            }
            changes.executeIfNeeded();
            this.results = AtsApiService.get().getWorkItemServiceIde().transition(this.helper);
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            if (this.results == null) {
                this.results = new TransitionResults();
            }
            this.results.addResult(new TransitionResult(String.format("Exception [%s] transitioning to [%s].  See error log for details.", ex.getLocalizedMessage(), this.helper.getToStateName())));
        }
    }

    public TransitionResults getResults() {
        return this.results;
    }
}

