/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.task.trace;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.nebula.widgets.xviewer.XViewerLabelProvider;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.ide.workflow.task.trace.TraceabilityContentProvider;
import org.eclipse.osee.ats.ide.workflow.task.trace.TraceabilityLabelProvider;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.results.IResultsEditorProvider;
import org.eclipse.osee.framework.ui.skynet.results.IResultsEditorTab;
import org.eclipse.osee.framework.ui.skynet.results.ResultsEditor;
import org.eclipse.osee.framework.ui.skynet.results.table.ResultsEditorTableTab;
import org.eclipse.osee.framework.ui.skynet.results.table.ResultsXViewerRow;
import org.eclipse.osee.framework.ui.skynet.results.table.xresults.ResultsXViewer;
import org.eclipse.osee.framework.ui.swt.Displays;

public class TraceabilityResultsEditor
extends AbstractOperation {
    private final List<Artifact> requirementArtifacts;

    public TraceabilityResultsEditor(String operationName, String pluginId, List<Artifact> requirementArtifacts) {
        super(operationName, pluginId);
        this.requirementArtifacts = requirementArtifacts;
    }

    protected void doWork(IProgressMonitor monitor) throws Exception {
        LinkedList<ResultsXViewerRow> artRows = new LinkedList<ResultsXViewerRow>();
        for (Artifact req : this.requirementArtifacts) {
            if (!req.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.AbstractSoftwareRequirement})) continue;
            artRows.add(new ResultsXViewerRow(new String[]{req.getName(), ""}, (Object)req));
        }
        List<XViewerColumn> artColumns = Arrays.asList(new XViewerColumn("Requirement", "Requirement", 500, XViewerAlign.Left, true, SortDataType.String, false, "Requirement Artifact"), new XViewerColumn("Relation", "Relation", 75, XViewerAlign.Left, true, SortDataType.String, false, "Relation Type"));
        final LinkedList<ResultsEditorTableTab> toReturn = new LinkedList<ResultsEditorTableTab>();
        ResultsEditorTableTab.IResultsEditorLabelProvider provider = new ResultsEditorTableTab.IResultsEditorLabelProvider(){

            public XViewerLabelProvider getLabelProvider(ResultsXViewer xViewer) {
                return new TraceabilityLabelProvider(xViewer);
            }
        };
        toReturn.add(new ResultsEditorTableTab("Traceability", artColumns, artRows, (ITreeContentProvider)new TraceabilityContentProvider(), provider));
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ResultsEditor.open((IResultsEditorProvider)new IResultsEditorProvider(){

                    public String getEditorName() {
                        return "Traceability Results Editor";
                    }

                    public List<IResultsEditorTab> getResultsEditorTabs() {
                        return toReturn;
                    }
                });
            }
        });
    }
}

