/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.task.related;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.task.ITaskEditorProvider;
import org.eclipse.osee.ats.ide.workflow.task.TaskArtifact;
import org.eclipse.osee.ats.ide.workflow.task.TaskEditorProvider;
import org.eclipse.osee.ats.ide.world.search.WorldSearchItem;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;

public class TaskEditorRelatedTasksProvider
extends TaskEditorProvider {
    private static final String BY_BUILD = "(By Build) ";
    private static final String BY_PROG = "(By Program) ";
    private static final String SHOW_ALL = "(Show All) ";
    private final boolean showAll;
    private final boolean byBuild;
    private final Collection<String> searchStrs;
    private final Collection<TaskArtifact> taskArts;
    private TaskArtifact taskArtifact;

    public TaskEditorRelatedTasksProvider(Collection<String> searchStrs, Collection<TaskArtifact> taskArts, boolean showAll, boolean byBuild) {
        super(null, XNavigateComposite.TableLoadOption.None);
        this.searchStrs = searchStrs;
        this.taskArts = taskArts;
        this.showAll = showAll;
        this.byBuild = byBuild;
    }

    private String getSearchType() {
        return !this.showAll && !this.byBuild ? BY_PROG : (!this.showAll ? BY_BUILD : SHOW_ALL);
    }

    @Override
    public String getTaskEditorLabel(WorldSearchItem.SearchType searchType) {
        return Strings.truncate((String)(String.valueOf(this.getSearchType()) + "Tasks for \"" + this.searchStrs + "\""), (int)80, (boolean)true);
    }

    public Collection<Artifact> performSearch(WorldSearchItem.SearchType searchType) {
        ArrayList<Artifact> arts = new ArrayList<Artifact>();
        ArrayList<Artifact> allArtifacts = new ArrayList<Artifact>();
        for (String searchStr : this.searchStrs) {
            allArtifacts.addAll(ArtifactQuery.getArtifactListFromTypeAndName((ArtifactTypeId)AtsArtifactTypes.Task, (String)searchStr, (BranchId)AtsApiService.get().getAtsBranch(), (QueryOption[])QueryOption.CONTAINS_MATCH_OPTIONS));
        }
        if (!this.showAll && !this.byBuild) {
            for (TaskArtifact taskArt : this.taskArts) {
                IAtsTeamDefinition teamDef = AtsApiService.get().getTeamDefinitionService().getTeamDefHoldingVersions(taskArt.getParentTeamWorkflow().getTeamDefinition());
                for (Artifact art : allArtifacts) {
                    this.taskArtifact = (TaskArtifact)art;
                    IAtsTeamDefinition teamDefinitionHoldingVersions = AtsApiService.get().getTeamDefinitionService().getTeamDefHoldingVersions(this.taskArtifact.getParentTeamWorkflow().getTeamDefinition());
                    if (teamDefinitionHoldingVersions == null || !teamDefinitionHoldingVersions.equals(teamDef)) continue;
                    arts.add(this.taskArtifact);
                }
            }
            return arts;
        }
        if (!this.showAll && this.byBuild) {
            for (TaskArtifact taskArt : this.taskArts) {
                String targetVer = AtsApiService.get().getVersionService().getTargetedVersionStr((IAtsWorkItem)taskArt, AtsApiService.get().getVersionService());
                for (Artifact art : allArtifacts) {
                    TaskArtifact taskArtifact = (TaskArtifact)art;
                    if (!AtsApiService.get().getVersionService().getTargetedVersionStr((IAtsWorkItem)taskArtifact, AtsApiService.get().getVersionService()).equals(targetVer)) continue;
                    arts.add(taskArtifact);
                }
            }
            return arts;
        }
        return allArtifacts;
    }

    @Override
    public String getName() {
        return this.getTaskEditorLabel(WorldSearchItem.SearchType.Search);
    }

    @Override
    public ITaskEditorProvider copyProvider() {
        return new TaskEditorRelatedTasksProvider(this.searchStrs, this.taskArts, this.showAll, this.byBuild);
    }
}

