/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.task.related;

import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osee.ats.api.task.related.DerivedFromTaskData;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.ide.actions.ISelectedAtsArtifacts;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.task.related.AbstractShowRelatedAction;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.jdk.core.type.MutableInteger;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.explorer.ArtifactExplorerUtil;
import org.eclipse.osee.framework.ui.swt.Displays;

public class ShowRelatedRequirementInArtifactExplorerAction
extends AbstractShowRelatedAction {
    LabelProvider relatedArtifactLabelProvider = new LabelProvider(){

        public String getText(Object element) {
            Artifact art = AtsApiService.get().getQueryServiceIde().getArtifact(element);
            if (art != null) {
                if (art.isHistorical()) {
                    return "[Rev:" + art.getTransaction() + "] - " + art.getName();
                }
                return "[Rev:Head] - " + art.getName();
            }
            return "";
        }
    };

    public ShowRelatedRequirementInArtifactExplorerAction(ISelectedAtsArtifacts selectedAtsArtifacts) {
        super("Show Related Requirement in Artifact Explorer", selectedAtsArtifacts);
    }

    public void run() {
        final List tasks = Collections.castAll(this.getSelectedTasks());
        if (!this.isAutoGenRelatedArtTasks(tasks)) {
            return;
        }
        final MutableInteger answer = new MutableInteger(-1);
        AbstractOperation openOp = new AbstractOperation("Show Related Requirement in Artifact Explorer", "org.eclipse.osee.ats.ide"){

            protected void doWork(IProgressMonitor monitor) throws Exception {
                Displays.ensureInDisplayThread((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        String taskStr = tasks.size() > 1 ? "these " + tasks.size() + " tasks" : ((IAtsTask)tasks.iterator().next()).getName();
                        String dialogMessage = String.format("Are you sure you want to open the latest requirement(s) for %s?\nNote: Deleted requirements will default to historical version.", taskStr);
                        MessageDialog dialog = new MessageDialog(Displays.getActiveShell(), "Show Related Requirement", null, dialogMessage, 0, new String[]{"OK", "Historical", "Cancel"}, 0);
                        answer.setValue(dialog.open());
                    }
                }, (boolean)true);
                boolean loadLatest = true;
                if (answer.getValue() == 1) {
                    loadLatest = false;
                } else if (answer.getValue() == 2) {
                    return;
                }
                ShowRelatedRequirementInArtifactExplorerAction.this.showRequirements(tasks, loadLatest);
            }
        };
        Operations.executeAsJob((IOperation)openOp, (boolean)true);
    }

    private void showRequirements(Collection<IAtsTask> tasks, boolean loadLatest) {
        for (IAtsTask task : tasks) {
            DerivedFromTaskData reqData = AtsApiService.get().getTaskRelatedService().getDerivedFromTaskData(task);
            if (reqData == null) continue;
            if (reqData.getResults().isErrors()) {
                AWorkbench.popup((String)reqData.getResults().toString());
                continue;
            }
            Artifact toOpen = null;
            toOpen = reqData.isDeleted() ? AtsApiService.get().getQueryServiceIde().getArtifact((ArtifactId)reqData.getHeadArtifact()) : (loadLatest ? AtsApiService.get().getQueryServiceIde().getArtifact((ArtifactId)reqData.getLatestArt()) : AtsApiService.get().getQueryServiceIde().getArtifact((ArtifactId)reqData.getHeadArtifact()));
            ArtifactExplorerUtil.revealArtifact((Artifact)toOpen);
        }
    }
}

