/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.task;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.api.workflow.IAtsTask;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.skynet.core.artifact.IATSStateMachineArtifact;

public class TaskArtifact
extends AbstractWorkflowArtifact
implements IAtsTask,
IATSStateMachineArtifact {
    Set<Long> taskHasNoParent = new HashSet<Long>();

    public TaskArtifact(Long id, String guid, BranchToken branch, ArtifactTypeToken artifactType) {
        super(id, guid, branch, artifactType);
    }

    public boolean isRelatedToParentWorkflowCurrentState() {
        return this.getSoleAttributeValueAsString((AttributeTypeToken)AtsAttributeTypes.RelatedToState, "").equals(this.getParentAWA().getStateMgr().getCurrentStateName());
    }

    public boolean isRelatedToUsed() {
        return Strings.isValid((String)this.getSoleAttributeValueAsString((AttributeTypeToken)AtsAttributeTypes.RelatedToState, ""));
    }

    public String getDescription() {
        try {
            return (String)this.getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.Description, "");
        }
        catch (Exception ex) {
            return "Error: " + ex.getLocalizedMessage();
        }
    }

    @Override
    public double getManHrsPerDayPreference() {
        return this.getParentAWA().getManHrsPerDayPreference();
    }

    @Override
    public AbstractWorkflowArtifact getParentAWA() {
        if (this.parentAwa != null) {
            return this.parentAwa;
        }
        this.parentAwa = (AbstractWorkflowArtifact)this.getRelatedArtifactOrNull(AtsRelationTypes.TeamWfToTask_TeamWorkflow);
        if (this.parentAwa == null && !this.taskHasNoParent.contains(this.getId())) {
            this.taskHasNoParent.add(this.getId());
            throw new OseeStateException("Task has no parent [%s]", new Object[]{this.getAtsId()});
        }
        return this.parentAwa;
    }

    @Override
    public IAtsAction getParentAction() {
        if (this.parentAction != null) {
            return this.parentAction;
        }
        this.parentAction = (IAtsAction)((AbstractWorkflowArtifact)this.getParentTeamWorkflow()).getParentAction().getStoreObject();
        return this.parentAction;
    }

    @Override
    public TeamWorkFlowArtifact getParentTeamWorkflow() {
        if (this.parentTeamArt != null) {
            return this.parentTeamArt;
        }
        AbstractWorkflowArtifact awa = this.getParentAWA();
        if (awa != null && awa.isTeamWorkflow()) {
            this.parentTeamArt = (TeamWorkFlowArtifact)awa;
        }
        return this.parentTeamArt;
    }
}

