/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.review;

import java.util.Date;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.api.workdef.IAtsDecisionReviewOption;
import org.eclipse.osee.ats.api.workdef.model.ReviewBlockType;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.AtsOpenOption;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.ats.ide.workflow.review.DecisionReviewArtifact;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactToken;

public class NewDecisionReviewJob
extends Job {
    private final TeamWorkFlowArtifact teamParent;
    private final ReviewBlockType reviewBlockType;
    private final String reviewTitle;
    private final String againstState;
    private final List<IAtsDecisionReviewOption> options;
    private final List<? extends AtsUser> assignees;
    private final String description;
    private final Date createdDate;
    private final AtsUser createdBy;

    public NewDecisionReviewJob(TeamWorkFlowArtifact teamParent, ReviewBlockType reviewBlockType, String reviewTitle, String againstState, String description, List<IAtsDecisionReviewOption> options, List<? extends AtsUser> assignees, Date createdDate, AtsUser createdBy) {
        super("Creating New Decision Review");
        this.teamParent = teamParent;
        this.reviewTitle = reviewTitle;
        this.againstState = againstState;
        this.reviewBlockType = reviewBlockType;
        this.description = description;
        this.options = options;
        this.assignees = assignees;
        this.createdDate = createdDate;
        this.createdBy = createdBy;
    }

    public IStatus run(IProgressMonitor monitor) {
        try {
            try {
                IAtsChangeSet changes = AtsApiService.get().createChangeSet(((Object)((Object)this)).getClass().getSimpleName());
                DecisionReviewArtifact decArt = (DecisionReviewArtifact)AtsApiService.get().getReviewService().createNewDecisionReview((IAtsTeamWorkflow)this.teamParent, this.reviewBlockType, this.reviewTitle, this.againstState, this.description, this.options, this.assignees, this.createdDate, this.createdBy, changes).getStoreObject();
                changes.execute();
                AtsEditors.openATSAction((ArtifactToken)decArt, AtsOpenOption.OpenOneOrPopupSelect);
            }
            catch (Exception ex) {
                monitor.done();
                Status status = new Status(4, "org.eclipse.osee.ats.ide", -1, "Error creating Decision Review", (Throwable)ex);
                monitor.done();
                return status;
            }
        }
        finally {
            monitor.done();
        }
        return Status.OK_STATUS;
    }
}

