/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.workflow.goal;

import java.util.List;
import org.eclipse.nebula.widgets.xviewer.IXViewerFactory;
import org.eclipse.osee.ats.api.data.AtsArtifactImages;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.workflow.IAtsGoal;
import org.eclipse.osee.ats.ide.AtsArtifactImageProvider;
import org.eclipse.osee.ats.ide.agile.BacklogXViewerFactory;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.goal.AbstractMemberProvider;
import org.eclipse.osee.ats.ide.workflow.goal.GoalArtifact;
import org.eclipse.osee.ats.ide.workflow.goal.GoalManager;
import org.eclipse.osee.ats.ide.workflow.goal.GoalXViewerFactory;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class GoalMemberProvider
extends AbstractMemberProvider {
    private IAtsGoal goal;

    public GoalMemberProvider(IAtsGoal goal) {
        this.goal = goal;
    }

    @Override
    public String getCollectorName() {
        if (this.isBacklog()) {
            return "Backlog";
        }
        return "Goal";
    }

    @Override
    public String getMembersName() {
        if (this.isBacklog()) {
            return "Items";
        }
        return "Members";
    }

    @Override
    public KeyedImage getImageKey() {
        if (this.isBacklog()) {
            return AtsArtifactImageProvider.getKeyedImage(AtsArtifactImages.AGILE_BACKLOG);
        }
        return ImageManager.create((OseeImage)AtsImage.GOAL);
    }

    @Override
    public List<Artifact> getMembers() {
        return this.getArtifact().getMembers();
    }

    @Override
    public GoalArtifact getArtifact() {
        return (GoalArtifact)this.goal.getStoreObject();
    }

    @Override
    public Long getId() {
        return this.getArtifact().getId();
    }

    @Override
    public void addMember(Artifact artifact) {
        this.getArtifact().addMember((ArtifactId)artifact);
    }

    @Override
    public IXViewerFactory getXViewerFactory(Artifact awa) {
        if (this.isBacklog()) {
            return new BacklogXViewerFactory((GoalArtifact)awa, this);
        }
        return new GoalXViewerFactory((GoalArtifact)awa, this);
    }

    @Override
    public String getColumnName() {
        if (this.isBacklog()) {
            return "ats.column.backlogOrder";
        }
        return "ats.column.goalOrder";
    }

    @Override
    public RelationTypeSide getMemberRelationTypeSide() {
        return AtsRelationTypes.Goal_Member;
    }

    @Override
    public void promptChangeOrder(Artifact goalArt, List<Artifact> selectedAtsArtifacts) {
        new GoalManager().promptChangeMemberOrder((GoalArtifact)goalArt, selectedAtsArtifacts);
    }

    @Override
    public Result isAddValid(List<Artifact> artifacts) {
        return Result.TrueResult;
    }

    @Override
    public boolean isBacklog() {
        return AtsApiService.get().getAgileService().isBacklog((Object)this.getArtifact());
    }

    @Override
    public boolean isSprint() {
        return false;
    }

    @Override
    public void setArtifact(Artifact artifact) {
        this.goal = (GoalArtifact)artifact;
    }
}

