/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.walker;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.osee.ats.ide.walker.ActionWalkerView;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.zest.layouts.LayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.AbstractLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.RadialLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.SpringLayoutAlgorithm;
import org.eclipse.zest.layouts.algorithms.TreeLayoutAlgorithm;

public class WalkerLayoutManager {
    private HashMap<String, AbstractLayoutAlgorithm> layouts;
    private static final String RADIAL_RIGHT_LAYOUT = "Radial - Right";
    private static final String RADIAL_DOWN_LAYOUT = "Radial - Down";
    private final List<String> layoutNames = new ArrayList<String>();
    private final ActionWalkerView view;
    private static final String defaultLayout = "Radial - Down";
    private String currentLayout = "Radial - Down";

    public WalkerLayoutManager(ActionWalkerView actionWalkerView) {
        this.view = actionWalkerView;
    }

    public void start() {
        this.ensureLoaded();
        this.view.setLayout((LayoutAlgorithm)this.layouts.get(this.currentLayout));
        this.view.refresh();
    }

    public void nextLayout() {
        int index = this.layoutNames.indexOf(this.currentLayout);
        if (index == -1) {
            this.currentLayout = "Radial - Down";
        }
        String nextLayout = "Radial - Down";
        if (this.layoutNames.size() > index + 1) {
            nextLayout = this.layoutNames.get(index + 1);
        }
        this.currentLayout = nextLayout;
        this.view.setLayout((LayoutAlgorithm)this.layouts.get(this.currentLayout));
        this.view.refresh();
    }

    public String getCurrentLayoutName() {
        return this.currentLayout;
    }

    public void ensureLoaded() {
        if (this.layouts == null) {
            this.layouts = new HashMap();
            RadialLayoutAlgorithm radLayout = new RadialLayoutAlgorithm(1);
            radLayout.setRangeToLayout(0.0, 1.5707963267948966);
            this.layouts.put("Radial - Down", (AbstractLayoutAlgorithm)radLayout);
            this.layoutNames.add("Radial - Down");
            radLayout = new RadialLayoutAlgorithm(1);
            radLayout.setRangeToLayout(-0.7853981633974483, 0.7853981633974483);
            this.layouts.put(RADIAL_RIGHT_LAYOUT, (AbstractLayoutAlgorithm)radLayout);
            this.layoutNames.add(RADIAL_RIGHT_LAYOUT);
            this.layouts.put("Radial - Full", (AbstractLayoutAlgorithm)new RadialLayoutAlgorithm(1));
            this.layoutNames.add("Radial - Full");
            this.layouts.put("Spring", (AbstractLayoutAlgorithm)new SpringLayoutAlgorithm());
            this.layoutNames.add("Spring");
            this.layouts.put("Tree", (AbstractLayoutAlgorithm)new TreeLayoutAlgorithm(1));
            this.layoutNames.add("Tree");
        }
    }

    public void init(IViewSite site, IMemento memento) {
        String layout;
        if (memento != null && Strings.isValid((String)(layout = memento.getString("Layout")))) {
            this.currentLayout = layout;
        }
    }

    public void saveState(IMemento memento) {
        if (memento != null && Strings.isValid((String)this.currentLayout)) {
            memento.putString("Layout", this.currentLayout);
        }
    }
}

