/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.role;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.review.IAtsPeerReviewRoleManager;
import org.eclipse.osee.ats.api.review.UserRole;
import org.eclipse.osee.ats.api.review.UserRoleError;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.ats.api.util.IAtsChangeSet;
import org.eclipse.osee.ats.core.review.ReviewDefectManager;
import org.eclipse.osee.ats.core.review.UserRoleManager;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsUtilClient;
import org.eclipse.osee.ats.ide.util.widgets.role.NewRoleDialog;
import org.eclipse.osee.ats.ide.util.widgets.role.UserRoleContentProvider;
import org.eclipse.osee.ats.ide.util.widgets.role.UserRoleLabelProvider;
import org.eclipse.osee.ats.ide.util.widgets.role.UserRoleXViewer;
import org.eclipse.osee.ats.ide.workflow.review.PeerToPeerReviewArtifact;
import org.eclipse.osee.ats.ide.workflow.review.role.UserRoleValidator;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.jdk.core.util.AHTML;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.event.OseeEventManager;
import org.eclipse.osee.framework.skynet.core.event.filter.IEventFilter;
import org.eclipse.osee.framework.skynet.core.event.listener.IArtifactEventListener;
import org.eclipse.osee.framework.skynet.core.event.listener.IEventListener;
import org.eclipse.osee.framework.skynet.core.event.model.ArtifactEvent;
import org.eclipse.osee.framework.skynet.core.event.model.Sender;
import org.eclipse.osee.framework.ui.plugin.PluginUiImage;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.widgets.ArtifactWidget;
import org.eclipse.osee.framework.ui.skynet.widgets.GenericXWidget;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Sash;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class XUserRoleViewer
extends GenericXWidget
implements ArtifactWidget,
IArtifactEventListener {
    private UserRoleXViewer xViewer;
    private PeerToPeerReviewArtifact reviewArt;
    public static final String normalColor = "#EEEEEE";
    private ToolItem newUserRoleItem;
    private ToolItem deleteUserRoleItem;
    private Label extraInfoLabel;
    private ToolBar toolBar;
    private IAtsPeerReviewRoleManager roleMgr;
    private static Map<PeerToPeerReviewArtifact, Integer> tableHeight = new HashMap<PeerToPeerReviewArtifact, Integer>();

    public XUserRoleViewer() {
        super("Roles");
        OseeEventManager.addListener((IEventListener)this);
    }

    public PeerToPeerReviewArtifact getArtifact() {
        return this.reviewArt;
    }

    protected void createControls(Composite parent, int horizontalSpan) {
        if (this.isDisplayLabel() && !this.getLabel().equals("")) {
            this.labelWidget = new Label(parent, 0);
            this.labelWidget.setText(String.valueOf(this.getLabel()) + ":");
            if (this.getToolTip() != null) {
                this.labelWidget.setToolTipText(this.getToolTip());
            }
        }
        final Composite mainComp = new Composite(parent, 2048);
        mainComp.setLayoutData((Object)new GridData(1808));
        mainComp.setLayout((Layout)ALayout.getZeroMarginLayout());
        if (this.toolkit != null) {
            this.toolkit.paintBordersFor(mainComp);
        }
        this.createTaskActionBar(mainComp);
        this.xViewer = new UserRoleXViewer(mainComp, 67586, this, this.getArtifact().getWorkDefinition());
        this.xViewer.setContentProvider((IContentProvider)new UserRoleContentProvider(this.xViewer));
        this.xViewer.setLabelProvider((IBaseLabelProvider)new UserRoleLabelProvider(this.xViewer));
        this.xViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                XUserRoleViewer.this.refreshActionEnablement();
            }
        });
        new ActionContributionItem((IAction)this.xViewer.getCustomizeAction()).fill(this.toolBar, -1);
        if (this.toolkit != null) {
            this.toolkit.adapt((Control)this.xViewer.getStatusLabel(), false, false);
        }
        this.refreshTableSize();
        Sash sash = new Sash(parent, 256);
        GridData gd = new GridData(768);
        gd.heightHint = 3;
        sash.setLayoutData((Object)gd);
        sash.setBackground(Displays.getSystemColor((int)15));
        sash.addListener(4, new Listener(){

            public void handleEvent(Event e) {
                Rectangle treeRect = XUserRoleViewer.this.xViewer.getTree().getClientArea();
                int newHeight = treeRect.height + e.y;
                XUserRoleViewer.this.setTableHeight(newHeight);
                XUserRoleViewer.this.refreshTableSize();
                mainComp.layout();
                XUserRoleViewer.this.xViewer.refresh();
                if (XUserRoleViewer.this.getForm(mainComp) != null) {
                    XUserRoleViewer.this.getForm(mainComp).reflow(true);
                }
            }
        });
        this.refresh();
    }

    private void refreshTableSize() {
        Tree tree = this.xViewer.getTree();
        GridData gridData = new GridData(1808);
        gridData.heightHint = this.getTableHeight();
        tree.setLayout((Layout)ALayout.getZeroMarginLayout());
        tree.setLayoutData((Object)gridData);
        tree.setHeaderVisible(true);
        tree.setLinesVisible(true);
    }

    public ScrolledForm getForm(Composite composite) {
        ScrolledForm form = null;
        if (composite == null) {
            return null;
        }
        if (composite instanceof ScrolledForm) {
            return (ScrolledForm)composite;
        }
        if (!(composite instanceof ScrolledForm)) {
            form = this.getForm(composite.getParent());
        }
        return form;
    }

    private int getTableHeight() {
        if (this.reviewArt != null && tableHeight.containsKey((Object)this.reviewArt)) {
            return tableHeight.get((Object)this.reviewArt);
        }
        return 100;
    }

    private void setTableHeight(int newHeight) {
        if (this.reviewArt != null) {
            if (newHeight < 100) {
                newHeight = 100;
            }
            tableHeight.put(this.reviewArt, newHeight);
        }
    }

    public void createTaskActionBar(Composite parent) {
        Composite bComp = new Composite(parent, 0);
        bComp.setLayout((Layout)new GridLayout(2, false));
        bComp.setLayoutData((Object)new GridData(768));
        Composite actionComp = new Composite(bComp, 0);
        actionComp.setLayout((Layout)new GridLayout());
        actionComp.setLayoutData((Object)new GridData(3));
        this.toolBar = new ToolBar(actionComp, 0x820000);
        GridData gd = new GridData(768);
        this.toolBar.setLayoutData((Object)gd);
        ToolItem item = null;
        this.newUserRoleItem = new ToolItem(this.toolBar, 8);
        this.newUserRoleItem.setImage(ImageManager.getImage((KeyedImage)FrameworkImage.USER_ADD));
        this.newUserRoleItem.setToolTipText("New Role");
        this.newUserRoleItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XUserRoleViewer.this.handleNewUserRole();
            }
        });
        this.deleteUserRoleItem = new ToolItem(this.toolBar, 8);
        this.deleteUserRoleItem.setImage(ImageManager.getImage((KeyedImage)FrameworkImage.X_RED));
        this.deleteUserRoleItem.setToolTipText("Delete Role");
        this.deleteUserRoleItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XUserRoleViewer.this.handleDeleteUserRole(false);
            }
        });
        item = new ToolItem(this.toolBar, 8);
        item.setImage(ImageManager.getImage((KeyedImage)PluginUiImage.REFRESH));
        item.setToolTipText("Refresh Roles");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XUserRoleViewer.this.refresh();
            }
        });
        Composite labelComp = new Composite(bComp, 0);
        labelComp.setLayout((Layout)new GridLayout());
        labelComp.setLayoutData((Object)new GridData(769));
        this.extraInfoLabel = new Label(labelComp, 0);
        this.extraInfoLabel.setLayoutData((Object)new GridData(768));
        this.extraInfoLabel.setText("");
        this.extraInfoLabel.setForeground(Displays.getSystemColor((int)3));
        this.refreshActionEnablement();
    }

    public void refreshActionEnablement() {
        if (this.deleteUserRoleItem != null && !this.deleteUserRoleItem.isDisposed()) {
            this.deleteUserRoleItem.setEnabled(this.isEditable() && this.getSelectedUserRoleItems().size() > 0);
        }
        if (this.newUserRoleItem != null && !this.newUserRoleItem.isDisposed()) {
            this.newUserRoleItem.setEnabled(this.isEditable());
        }
    }

    public void handleDeleteUserRole(boolean persist) {
        List<UserRole> items = this.getSelectedUserRoleItems();
        if (items.isEmpty()) {
            AWorkbench.popup((String)"ERROR", (String)"No Roles Selected");
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (UserRole userRole : items) {
            builder.append("\"" + userRole.toString() + "\"\n");
        }
        boolean delete = MessageDialog.openQuestion((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)"Delete Roles", (String)("Are You Sure You Wish to Delete the Roles(s):\n\n" + builder.toString()));
        if (delete) {
            try {
                IAtsChangeSet changes = AtsApiService.get().createChangeSet("Delete Review Roles");
                for (UserRole userRole : items) {
                    this.roleMgr.removeUserRole(userRole);
                    this.roleMgr.saveToArtifact(changes);
                }
                this.notifyXModifiedListeners();
                changes.execute();
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
        }
    }

    public void handleNewUserRole() {
        NewRoleDialog dialog = new NewRoleDialog(this.reviewArt.getWorkDefinition());
        dialog.setReview(this.reviewArt);
        if (dialog.open() == 0) {
            try {
                IAtsChangeSet changes = AtsApiService.get().createChangeSet("Add Review Roles");
                for (AtsUser user : dialog.getUsers()) {
                    UserRole userRole = new UserRole(dialog.getRole(), user);
                    this.roleMgr.addOrUpdateUserRole(userRole);
                    changes.add((Object)this.reviewArt);
                }
                this.roleMgr.saveToArtifact(changes);
                changes.execute();
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
            }
            this.notifyXModifiedListeners();
        }
    }

    public List<UserRole> getSelectedUserRoleItems() {
        ArrayList<UserRole> items = new ArrayList<UserRole>();
        if (this.xViewer == null) {
            return items;
        }
        if (this.xViewer.getSelection().isEmpty()) {
            return items;
        }
        for (Object obj : (IStructuredSelection)this.xViewer.getSelection()) {
            items.add((UserRole)obj);
        }
        return items;
    }

    public Control getControl() {
        return this.xViewer.getTree();
    }

    public void dispose() {
        OseeEventManager.removeListener((IEventListener)this);
        this.xViewer.dispose();
    }

    public void refresh() {
        if (this.xViewer == null || this.xViewer.getTree() == null || this.xViewer.getTree().isDisposed()) {
            return;
        }
        this.roleMgr = this.reviewArt.getRoleManager();
        this.xViewer.set(this.roleMgr.getUserRoles());
        this.validate();
        this.refreshActionEnablement();
    }

    public IStatus isValid() {
        try {
            UserRoleError error = UserRoleValidator.isValid(this.reviewArt.getArtifact());
            if (error.equals((Object)UserRoleError.MustMeetMinimumRole)) {
                this.extraInfoLabel.setText("At least one role entry is required. Select \"New Role\" to add.");
                this.extraInfoLabel.setForeground(Displays.getSystemColor((int)3));
                return new Status(4, ((Object)((Object)this)).getClass().getSimpleName(), "At least one role entry is required");
            }
            if (!error.isOK()) {
                this.extraInfoLabel.setText(String.valueOf(error.getError()) + " Select \"New Role\" to add.");
                this.extraInfoLabel.setForeground(Displays.getSystemColor((int)3));
                return new Status(4, ((Object)((Object)this)).getClass().getSimpleName(), error.getError());
            }
            this.extraInfoLabel.setText("Select \"New Role\" to add.");
            this.extraInfoLabel.setForeground(Displays.getSystemColor((int)2));
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return new Status(4, ((Object)((Object)this)).getClass().getSimpleName(), "Exception validating roles. See log for details. " + ex.getLocalizedMessage(), (Throwable)ex);
        }
        return new Status(0, ((Object)((Object)this)).getClass().getSimpleName(), "");
    }

    public boolean isEmpty() {
        return this.xViewer.getTree().getItemCount() == 0;
    }

    public String toHTML(String labelFont) {
        StringBuffer html = new StringBuffer();
        try {
            html.append(String.valueOf(AHTML.addSpace((int)1)) + AHTML.getLabelStr((String)"<font color=\"black\" face=\"Arial\" size=\"-1\">", (String)"Tasks"));
            html.append(AHTML.startBorderTable((int)100, (String)normalColor, (String)""));
            html.append(AHTML.addHeaderRowMultiColumnTable((String[])new String[]{"Role", "User", "Hours", "Major", "Minor", "Issues"}));
            ReviewDefectManager defectMgr = new ReviewDefectManager((ArtifactToken)this.reviewArt, (AtsApi)AtsApiService.get());
            for (UserRole item : this.roleMgr.getUserRoles()) {
                AtsUser atsUser = UserRoleManager.getUser((UserRole)item, (AtsApi)AtsApiService.get());
                html.append(AHTML.addRowMultiColumnTable((String[])new String[]{item.getRole().getName(), atsUser.getName(), AtsUtil.doubleToI18nString((double)item.getHoursSpent()), String.valueOf(defectMgr.getNumMajor(atsUser)), String.valueOf(defectMgr.getNumMinor(atsUser)), String.valueOf(defectMgr.getNumIssues(atsUser))}));
            }
            html.append(AHTML.endBorderTable());
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            return "User Role Item Exception - " + ex.getLocalizedMessage();
        }
        return html.toString();
    }

    public Object getData() {
        return this.xViewer.getInput();
    }

    public PeerToPeerReviewArtifact getReviewArt() {
        return this.reviewArt;
    }

    public void setReviewArt(PeerToPeerReviewArtifact reviewArt) {
        this.reviewArt = reviewArt;
        this.roleMgr = reviewArt.getRoleManager();
        if (this.xViewer != null) {
            this.refresh();
        }
    }

    public void setArtifact(Artifact artifact) {
        this.setReviewArt((PeerToPeerReviewArtifact)artifact);
    }

    public void saveToArtifact() {
    }

    public Result isDirty() {
        return Result.FalseResult;
    }

    public void revert() {
    }

    public Control getErrorMessageControl() {
        return this.labelWidget;
    }

    public List<? extends IEventFilter> getEventFilters() {
        return Arrays.asList(AtsUtilClient.getAtsBranchFilter(), AtsUtilClient.getReviewArtifactTypeEventFilter());
    }

    public void handleArtifactEvent(final ArtifactEvent artifactEvent, Sender sender) {
        if (this.reviewArt == null || !artifactEvent.isHasEvent(this.reviewArt.getArtifact())) {
            return;
        }
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                if (XUserRoleViewer.this.xViewer == null || XUserRoleViewer.this.xViewer.getTree() == null || XUserRoleViewer.this.xViewer.getTree().isDisposed()) {
                    return;
                }
                if (artifactEvent.isRelAddedChangedDeleted(XUserRoleViewer.this.reviewArt.getArtifact())) {
                    XUserRoleViewer.this.refresh();
                }
            }
        });
    }

    public IAtsPeerReviewRoleManager getUserRoleMgr() {
        return this.roleMgr;
    }
}

