/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.dialog;

import java.util.Map;
import java.util.logging.Level;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.ArrayTreeContentProvider;
import org.eclipse.osee.framework.ui.plugin.util.StringLabelProvider;
import org.eclipse.osee.framework.ui.skynet.internal.Activator;
import org.eclipse.osee.framework.ui.skynet.util.StringNameComparator;
import org.eclipse.osee.framework.ui.skynet.widgets.XCheckBox;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.FilteredTreeDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ViewBranchViewFilterTreeDialog
extends FilteredTreeDialog {
    private Long selection;
    XCheckBox showAll = new XCheckBox("Show All Branch Views");
    private final Map<Long, String> branchViews;

    public ViewBranchViewFilterTreeDialog(String title, String message, Map<Long, String> branchViews) {
        super(title, message, (IContentProvider)new ArrayTreeContentProvider(), (IBaseLabelProvider)new StringLabelProvider());
        this.branchViews = branchViews;
    }

    protected Control createDialogArea(Composite container) {
        Control comp = super.createDialogArea(container);
        try {
            this.getTreeViewer().getViewer().setComparator((ViewerComparator)new StringNameComparator());
            this.getTreeViewer().getViewer().addPostSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    IStructuredSelection sel = (IStructuredSelection)ViewBranchViewFilterTreeDialog.this.getTreeViewer().getViewer().getSelection();
                    if (sel.isEmpty()) {
                        ViewBranchViewFilterTreeDialog.this.selection = null;
                    } else {
                        Object selElement = sel.getFirstElement();
                        for (Map.Entry entry : ViewBranchViewFilterTreeDialog.this.branchViews.entrySet()) {
                            if (!((String)entry.getValue()).equals(selElement)) continue;
                            ViewBranchViewFilterTreeDialog.this.selection = (Long)entry.getKey();
                            break;
                        }
                        if (ViewBranchViewFilterTreeDialog.this.selection == null) {
                            ViewBranchViewFilterTreeDialog.this.selection = -1L;
                        }
                    }
                    ViewBranchViewFilterTreeDialog.this.updateStatusLabel();
                }
            });
            GridData gd = new GridData(1808);
            gd.heightHint = 500;
            this.getTreeViewer().getViewer().getTree().setLayoutData((Object)gd);
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return comp;
    }

    protected Result isComplete() {
        try {
            if (this.selection == null) {
                return new Result("A View Applicability must be selected.");
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return Result.TrueResult;
    }

    public Long getSelection() {
        return this.selection;
    }
}

