/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets.dialog;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osee.ats.api.AtsApi;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.api.util.AtsUserNameComparator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.dialog.FilteredTreeAtsUserDialog;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.ui.plugin.util.ArrayTreeContentProvider;
import org.eclipse.osee.framework.ui.skynet.ArtifactLabelProvider;
import org.eclipse.swt.widgets.Shell;

public class UserListDialog
extends FilteredTreeAtsUserDialog {
    AtsApi atsApi;

    public UserListDialog(Shell parent, Active active) {
        this(parent, "Select User", active);
    }

    public UserListDialog(Shell parent, String title, Active active) {
        this(parent, title, UserListDialog.getDefaultUsers(active, AtsApiService.get()));
    }

    public UserListDialog(Shell parent, String title, Collection<AtsUser> users) {
        super(title, title, users, (ITreeContentProvider)new ArrayTreeContentProvider(), (ILabelProvider)new LabelProvider());
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.atsApi = AtsApiService.get();
    }

    private static Collection<AtsUser> getDefaultUsers(Active active, AtsApi atsApi) {
        ArrayList<AtsUser> users = new ArrayList<AtsUser>();
        if (active == Active.Both) {
            users.addAll(atsApi.getConfigService().getConfigurations().getIdToUser().values());
            Collections.sort(users, new AtsUserNameComparator());
        } else if (active == Active.Active) {
            for (AtsUser aUser : atsApi.getConfigService().getConfigurations().getIdToUser().values()) {
                if (!aUser.isActive()) continue;
                users.add(aUser);
            }
            Collections.sort(users, new AtsUserNameComparator());
        } else {
            for (AtsUser aUser : atsApi.getConfigService().getConfigurations().getIdToUser().values()) {
                if (aUser.isActive()) continue;
                users.add(aUser);
            }
            Collections.sort(users, new AtsUserNameComparator());
        }
        return users;
    }

    public AtsUser getSelection() {
        return super.getSelectedFirst();
    }

    public static class UserArtifactLabelProvider
    extends ArtifactLabelProvider {
        public String getText(Object element) {
            if (element instanceof AtsUser) {
                return ((AtsUser)element).getName();
            }
            return "Unknown Object";
        }
    }
}

