/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.logging.Level;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.editor.tab.workflow.header.WfeTargetedVersionHeader;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.widgets.XWorkingBranchButtonAbstract;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.util.Result;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class XWorkingBranchButtonCreate
extends XWorkingBranchButtonAbstract {
    public static String WIDGET_NAME = "XWorkingBranchButtonCreate";

    @Override
    protected void initButton(final Button button) {
        button.setToolTipText("Create Working Branch");
        button.setImage(ImageManager.getImage((KeyedImage)FrameworkImage.BRANCH));
        button.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                XWorkingBranchButtonCreate.this.disableAll = true;
                XWorkingBranchButtonCreate.this.refreshEnablement(button);
                Result result = AtsApiService.get().getBranchServiceIde().createWorkingBranch_Validate(XWorkingBranchButtonCreate.this.getTeamArt());
                boolean appropriate = XWorkingBranchButtonCreate.this.selectTargetedVersionOrConfigureParentBranchIfAppropriate(result, button);
                if (appropriate) {
                    XWorkingBranchButtonCreate.this.disableAll = false;
                    XWorkingBranchButtonCreate.this.refreshEnablement(button);
                    return;
                }
                if (result.isFalse()) {
                    AWorkbench.popup((Result)result);
                    XWorkingBranchButtonCreate.this.disableAll = false;
                    XWorkingBranchButtonCreate.this.refreshEnablement(button);
                    return;
                }
                try {
                    String workingBranchName = AtsApiService.get().getBranchService().getBranchName((IAtsTeamWorkflow)XWorkingBranchButtonCreate.this.getTeamArt());
                    BranchId parentBranch = AtsApiService.get().getBranchService().getConfiguredBranchForWorkflow((IAtsTeamWorkflow)XWorkingBranchButtonCreate.this.getTeamArt());
                    if (parentBranch.isValid()) {
                        String pBranchName = AtsApiService.get().getBranchService().getBranchName(parentBranch);
                        if (!MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)"Create Working Branch", (String)("Creating working branch:\n\n\"" + workingBranchName + "\"\n\nfrom parent branch: \n\n\"" + pBranchName + "\"\n\nIs that correct?\n\n" + "---\nNOTE: Working branches are necessary when OSEE Artifact changes " + "are made during implementation."))) {
                            XWorkingBranchButtonCreate.this.disableAll = false;
                            XWorkingBranchButtonCreate.this.refreshEnablement(button);
                            return;
                        }
                        button.setText("Creating Branch...");
                        button.redraw();
                        button.getParent().layout();
                        AtsApiService.get().getBranchServiceIde().createWorkingBranch_Create((IAtsTeamWorkflow)XWorkingBranchButtonCreate.this.getTeamArt(), false);
                    }
                }
                catch (Exception ex) {
                    OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
                    XWorkingBranchButtonCreate.this.disableAll = false;
                    XWorkingBranchButtonCreate.this.refreshEnablement(button);
                }
            }
        });
    }

    private boolean selectTargetedVersionOrConfigureParentBranchIfAppropriate(Result result, Button button) {
        boolean returnVal = false;
        if (result.getText().equals("Parent Branch cannot be determined.\n\nPlease specify parent branch through Targeted Version or Team Definition.\n\nContact your team lead to configure this.")) {
            returnVal = true;
            IAtsVersion version = AtsApiService.get().getVersionService().getTargetedVersion((IAtsWorkItem)this.getTeamArt());
            if (version == null) {
                MessageDialog dialog = new MessageDialog(Displays.getActiveShell(), "Create Working Branch", null, "Parent Branch cannot be determined.\n\nPlease specify parent branch through Targeted Version or Team Definition.\n\nContact your team lead to configure this.", 1, new String[]{"Select Targeted Version", "Cancel"}, 0);
                if (dialog.open() == 0) {
                    WfeTargetedVersionHeader.promptChangeVersion(this.getTeamArt());
                }
            } else {
                MessageDialog dialog = new MessageDialog(Displays.getActiveShell(), "Create Working Branch", null, "Parent Branch cannot be determined.\n\nPlease specify parent branch through Targeted Version or Team Definition.\n\nContact your team lead to configure this.", 1, new String[]{"Ok", "Cancel"}, 0);
                dialog.open();
            }
        }
        return returnVal;
    }

    @Override
    protected void refreshEnablement(Button button) {
        boolean enabled = !this.disableAll && !this.isWorkingBranchCreationInProgress() && !this.isWorkingBranchCommitInProgress() && !this.isWorkingBranchInWork() && !this.isCommittedBranchExists() && this.isWidgetAllowedInCurrentState();
        button.setText("");
        button.getParent().layout();
        button.setEnabled(enabled);
    }

    @Override
    protected boolean isWidgetAllowedInCurrentState() {
        return this.isWidgetInState(WIDGET_NAME);
    }
}

