/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.util.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.osee.ats.api.data.AtsArtifactTypes;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.program.IAtsProgram;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.QueryOption;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.skynet.widgets.XArtifactSelectWidgetWithSave;

public class XProgramSelectionWidget
extends XArtifactSelectWidgetWithSave {
    public static final String WIDGET_ID = XProgramSelectionWidget.class.getSimpleName();
    private final List<ArtifactId> programArts = new ArrayList<ArtifactId>();

    public XProgramSelectionWidget() {
        super("Program");
        this.setupPrograms();
    }

    public Artifact getStored() {
        ArtifactId artId = (ArtifactId)this.getArtifact().getSoleAttributeValue((AttributeTypeId)AtsAttributeTypes.ProgramId, null);
        return ArtifactQuery.getArtifactFromId((ArtifactId)artId, (BranchId)this.getArtifact().getBranch());
    }

    public void setupPrograms() {
        Collection programs = AtsApiService.get().getProgramService().getPrograms(AtsArtifactTypes.Program);
        for (IAtsProgram program : programs) {
            if (!program.isActive()) continue;
            this.programArts.add((ArtifactId)AtsApiService.get().getQueryService().getArtifactById(program.getIdString()));
        }
    }

    public Collection<Artifact> getSelectableArtifacts() {
        Collection programArts = AtsApiService.get().getQueryService().createQuery(new ArtifactTypeToken[]{AtsArtifactTypes.Program}).andAttr((AttributeTypeId)AtsAttributeTypes.Active, "true", new QueryOption[0]).getArtifacts();
        return Collections.castAll((Collection)programArts);
    }
}

