/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.navigate.report;

import java.io.File;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.ide.config.version.VersionReportJob;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.navigate.AtsNavigateViewItems;
import org.eclipse.osee.ats.ide.util.widgets.dialog.TeamDefinitionDialog;
import org.eclipse.osee.framework.core.enums.Active;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItemAction;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;

public class PublishFullVersionReportItem
extends XNavigateItemAction {
    private final IAtsTeamDefinition teamDef;
    private final String publishToFilename;

    public PublishFullVersionReportItem(String name, IAtsTeamDefinition teamDef, String publishToFilename) {
        super(name, new XNavItemCat[]{AtsNavigateViewItems.ATS_VERSIONS});
        this.teamDef = teamDef;
        this.publishToFilename = publishToFilename;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void run(XNavigateComposite.TableLoadOption ... tableLoadOptions) {
        IAtsTeamDefinition useTeamDef;
        String usePublishToFilename = this.publishToFilename;
        if (usePublishToFilename == null) {
            FileDialog dialog = new FileDialog(Displays.getActiveShell().getShell(), 8192);
            dialog.setFilterExtensions(new String[]{"*.html"});
            usePublishToFilename = dialog.open();
            if (usePublishToFilename == null) {
                return;
            }
        }
        if ((useTeamDef = this.teamDef) == null) {
            List teamDefinitions = null;
            try {
                teamDefinitions = AtsApiService.get().getTeamDefinitionService().getTeamDefinitions(Active.Both);
            }
            catch (OseeCoreException ex) {
                OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Error loading team definitions", (Throwable)ex);
            }
            TeamDefinitionDialog dialog = new TeamDefinitionDialog();
            dialog.setInput(teamDefinitions);
            int result = dialog.open();
            if (result != 0) return;
            useTeamDef = (IAtsTeamDefinition)dialog.getSelectedFirst();
        } else if (!MessageDialog.openConfirm((Shell)Displays.getActiveShell(), (String)this.getName(), (String)this.getName())) {
            return;
        }
        String title = useTeamDef == null ? "teamDef is null" : String.valueOf(useTeamDef.getName()) + " Version Report";
        PublishReportJob job = new PublishReportJob(title, this.teamDef, usePublishToFilename);
        job.setUser(true);
        job.setPriority(30);
        job.schedule();
    }

    private static class PublishReportJob
    extends Job {
        private final IAtsTeamDefinition teamDef;
        private final String filename;

        public PublishReportJob(String title, IAtsTeamDefinition teamDef, String filename) {
            super(title);
            this.teamDef = teamDef;
            this.filename = filename;
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                String html = VersionReportJob.getFullReleaseReport(this.teamDef, monitor);
                Lib.writeStringToFile((String)html, (File)new File(this.filename));
                Program.launch((String)this.filename);
                AWorkbench.popup((String)"Publish Complete", (String)("Data Published To \"" + this.filename + "\""));
            }
            catch (Exception ex) {
                return new Status(4, "org.eclipse.osee.ats.ide", -1, ex.toString(), (Throwable)ex);
            }
            monitor.done();
            return Status.OK_STATUS;
        }
    }
}

