/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor.tab.workflow.widget;

import java.util.List;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.osee.ats.api.user.AtsCoreUsers;
import org.eclipse.osee.ats.api.user.AtsUser;
import org.eclipse.osee.ats.ide.util.AtsUserLabelProvider;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.widgets.XListViewer;
import org.eclipse.osee.framework.ui.swt.ALayout;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public abstract class AbstractXAssigneesListWidget
extends XListViewer {
    public AbstractXAssigneesListWidget(String displayLabel) {
        super(displayLabel);
    }

    protected void createControls(Composite parent, int horizontalSpan) {
        this.setLabelProvider((ILabelProvider)new AtsUserLabelProvider());
        this.setContentProvider((IContentProvider)new ArrayContentProvider());
        super.createControls(parent, horizontalSpan);
        this.setVerticalLabel(true);
        List<AtsUser> assignees = this.getCurrentAssignees();
        assignees.remove(AtsCoreUsers.UNASSIGNED_USER);
        this.setInput(assignees);
        GridData gd = new GridData(4, 0, true, false);
        gd.horizontalSpan = 2;
        gd.heightHint = 60;
        gd.widthHint = 60;
        this.getTable().setLayoutData((Object)gd);
    }

    public abstract List<AtsUser> getCurrentAssignees();

    public abstract void handleModifySelection();

    public abstract void handleEmailSelection();

    public abstract boolean includeEmailButton();

    protected void createControlsAfterLabel(Composite parent, int horizontalSpan) {
        Composite mComp = new Composite(parent, 0x800000);
        GridData gd = new GridData(4, 0, false, false);
        gd.horizontalSpan = 2;
        mComp.setLayoutData((Object)gd);
        mComp.setLayout((Layout)ALayout.getZeroMarginLayout((int)2, (boolean)false));
        mComp.setBackgroundMode(2);
        Button modifyList = new Button(mComp, 8);
        modifyList.setImage(ImageManager.getImage((KeyedImage)FrameworkImage.EDIT));
        modifyList.setToolTipText("Select to modify");
        modifyList.setLayoutData((Object)new GridData(16384, 0, false, false));
        modifyList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AbstractXAssigneesListWidget.this.handleModifySelection();
            }
        });
        if (this.includeEmailButton()) {
            Button emailSelected = new Button(mComp, 8);
            emailSelected.setImage(ImageManager.getImage((KeyedImage)FrameworkImage.EMAIL));
            emailSelected.setToolTipText("Email");
            emailSelected.setLayoutData((Object)new GridData(16384, 0, false, false));
            emailSelected.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    AbstractXAssigneesListWidget.this.handleEmailSelection();
                }
            });
        }
    }
}

