/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.editor;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.data.AtsArtifactImages;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.AtsArtifactImageProvider;
import org.eclipse.osee.ats.ide.editor.WfeInputFactory;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.type.Id;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.skynet.artifact.editor.ArtifactEditorInput;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class WfeInput
extends ArtifactEditorInput {
    public WfeInput(Artifact artifact) {
        super(artifact);
    }

    public WfeInput(BranchId branch, ArtifactId artId, String title) {
        super(branch, artId, title);
    }

    public boolean isReload() {
        return this.getArtifact() == null;
    }

    public IPersistableElement getPersistable() {
        return this;
    }

    public void saveState(IMemento memento) {
        WfeInputFactory.saveState(memento, this);
    }

    public String getFactoryId() {
        return "org.eclipse.osee.ats.ide.WEEditorInputFactory";
    }

    public String getName() {
        String name = this.getSavedTitle();
        if (this.getArtifact() != null && !this.getArtifact().isDeleted()) {
            name = this.isBacklog() ? "Backlog: " + this.getArtifact().getName() : ((AbstractWorkflowArtifact)this.getArtifact()).getEditorTitle();
        }
        return name;
    }

    boolean isBacklog() {
        return AtsApiService.get().getAgileService().isBacklog((Object)this.getArtifact());
    }

    public ImageDescriptor getImageDescriptor() {
        if (AtsApiService.get().getAgileService().isBacklog((Object)this.getArtifact())) {
            return ImageManager.getImageDescriptor((KeyedImage)AtsArtifactImageProvider.getKeyedImage(AtsArtifactImages.AGILE_BACKLOG));
        }
        return ImageManager.getImageDescriptor((OseeImage)AtsImage.WORKFLOW);
    }

    public boolean equals(Object obj) {
        if (obj instanceof WfeInput) {
            WfeInput other = (WfeInput)((Object)obj);
            if (this.getArtId().notEqual((Id)other.getArtId())) {
                return false;
            }
            return this.getBranchId().equals(other.getBranchId());
        }
        return false;
    }
}

