/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.config.version;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osee.ats.api.data.AtsRelationTypes;
import org.eclipse.osee.ats.api.team.IAtsTeamDefinition;
import org.eclipse.osee.ats.api.version.IAtsVersion;
import org.eclipse.osee.ats.api.workflow.IAtsTeamWorkflow;
import org.eclipse.osee.ats.ide.config.version.VersionMetrics;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.teamwf.TeamWorkFlowArtifact;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.skynet.core.relation.RelationManager;

public class VersionTeamMetrics {
    private final IAtsTeamDefinition verTeamDef;
    private final List<VersionMetrics> releasedOrderedVersions = new ArrayList<VersionMetrics>();
    private final Set<VersionMetrics> verMets = new HashSet<VersionMetrics>();
    Map<Date, VersionMetrics> relDateToVerMet = new HashMap<Date, VersionMetrics>();
    private Map<TeamWorkFlowArtifact, Date> teamWorkflowToOrigDate = null;

    public VersionTeamMetrics(IAtsTeamDefinition verTeamDef) {
        this.verTeamDef = verTeamDef;
        this.loadMetrics();
    }

    private void loadMetrics() {
        this.bulkLoadArtifacts();
        this.orderReleasedVersions();
    }

    private void bulkLoadArtifacts() {
        RelationManager.getRelatedArtifacts(Arrays.asList(AtsApiService.get().getQueryServiceIde().getArtifact(this.verTeamDef)), (int)6, (RelationTypeSide[])new RelationTypeSide[]{CoreRelationTypes.DefaultHierarchical_Child, AtsRelationTypes.TeamDefinitionToVersion_Version, AtsRelationTypes.TeamWorkflowTargetedForVersion_TeamWorkflow, AtsRelationTypes.TeamWfToTask_Task, AtsRelationTypes.ActionToWorkflow_Action});
    }

    public Collection<TeamWorkFlowArtifact> getWorkflowsOriginatedBetween(Date startDate, Date endDate) {
        if (this.teamWorkflowToOrigDate == null) {
            this.teamWorkflowToOrigDate = new HashMap<TeamWorkFlowArtifact, Date>();
            for (IAtsVersion verArt : AtsApiService.get().getVersionService().getVersions(this.verTeamDef)) {
                for (IAtsTeamWorkflow team : AtsApiService.get().getVersionService().getTargetedForTeamWorkflows(verArt)) {
                    Date origDate = team.getCreatedDate();
                    this.teamWorkflowToOrigDate.put((TeamWorkFlowArtifact)team.getStoreObject(), origDate);
                }
            }
        }
        HashSet<TeamWorkFlowArtifact> teams = new HashSet<TeamWorkFlowArtifact>();
        for (Map.Entry<TeamWorkFlowArtifact, Date> entry : this.teamWorkflowToOrigDate.entrySet()) {
            if (entry.getValue() == null || !entry.getValue().after(startDate) || !entry.getValue().before(endDate)) continue;
            teams.add(entry.getKey());
        }
        return teams;
    }

    private void orderReleasedVersions() {
        for (IAtsVersion verArt : AtsApiService.get().getVersionService().getVersions(this.verTeamDef)) {
            VersionMetrics verMet = new VersionMetrics(verArt, this);
            Date relDate = AtsApiService.get().getVersionService().getReleaseDate(verArt);
            if (relDate != null) {
                this.relDateToVerMet.put(relDate, verMet);
            }
            this.verMets.add(verMet);
        }
        Object[] releases = this.relDateToVerMet.keySet().toArray(new Date[this.relDateToVerMet.keySet().size()]);
        Arrays.sort(releases);
        Object[] objectArray = releases;
        int n = releases.length;
        int n2 = 0;
        while (n2 < n) {
            Object date = objectArray[n2];
            this.releasedOrderedVersions.add(this.relDateToVerMet.get(date));
            ++n2;
        }
    }

    public List<VersionMetrics> getReleasedOrderedVersions() {
        return this.releasedOrderedVersions;
    }
}

