/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.config.editor;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.nebula.widgets.xviewer.XViewerLabelProvider;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsConfigObject;
import org.eclipse.osee.ats.ide.config.editor.AtsConfigContentProvider;
import org.eclipse.osee.ats.ide.config.editor.AtsConfigLabelProvider;
import org.eclipse.osee.framework.core.operation.AbstractOperation;
import org.eclipse.osee.framework.ui.skynet.results.IResultsEditorProvider;
import org.eclipse.osee.framework.ui.skynet.results.IResultsEditorTab;
import org.eclipse.osee.framework.ui.skynet.results.ResultsEditor;
import org.eclipse.osee.framework.ui.skynet.results.table.ResultsEditorTableTab;
import org.eclipse.osee.framework.ui.skynet.results.table.ResultsXViewerRow;
import org.eclipse.osee.framework.ui.skynet.results.table.xresults.ResultsXViewer;
import org.eclipse.osee.framework.ui.swt.Displays;

public class AtsConfigResultsEditor
extends AbstractOperation {
    private final List<IAtsConfigObject> configObjects;

    public AtsConfigResultsEditor(String operationName, String pluginId, List<IAtsConfigObject> configObjects) {
        super(operationName, pluginId);
        this.configObjects = configObjects;
    }

    protected void doWork(IProgressMonitor monitor) throws Exception {
        LinkedList<ResultsXViewerRow> artRows = new LinkedList<ResultsXViewerRow>();
        for (IAtsConfigObject obj : this.configObjects) {
            artRows.add(new ResultsXViewerRow(new String[]{obj.getName(), ""}, (Object)obj));
        }
        List<XViewerColumn> artColumns = Arrays.asList(new XViewerColumn("Type", "Type", 175, XViewerAlign.Left, true, SortDataType.String, false, "Type"), new XViewerColumn("Name", "Name", 300, XViewerAlign.Left, true, SortDataType.String, false, "Name"), new XViewerColumn("Id", "Id", 150, XViewerAlign.Left, true, SortDataType.String, false, "Id"));
        final LinkedList<ResultsEditorTableTab> toReturn = new LinkedList<ResultsEditorTableTab>();
        ResultsEditorTableTab.IResultsEditorLabelProvider provider = new ResultsEditorTableTab.IResultsEditorLabelProvider(){

            public XViewerLabelProvider getLabelProvider(ResultsXViewer xViewer) {
                return new AtsConfigLabelProvider(xViewer);
            }
        };
        toReturn.add(new ResultsEditorTableTab("Config", artColumns, artRows, (ITreeContentProvider)new AtsConfigContentProvider(), provider));
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                ResultsEditor.open((IResultsEditorProvider)new IResultsEditorProvider(){

                    public String getEditorName() {
                        return "ATS Config Viewer";
                    }

                    public List<IResultsEditorTab> getResultsEditorTabs() {
                        return toReturn;
                    }
                });
            }
        });
    }
}

