/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.column.ev;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.nebula.widgets.xviewer.IAltLeftClickProvider;
import org.eclipse.nebula.widgets.xviewer.IMultiColumnEditProvider;
import org.eclipse.nebula.widgets.xviewer.IXViewerValueColumn;
import org.eclipse.nebula.widgets.xviewer.core.model.SortDataType;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerAlign;
import org.eclipse.nebula.widgets.xviewer.core.model.XViewerColumn;
import org.eclipse.osee.ats.api.IAtsObject;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.column.IAtsColumnId;
import org.eclipse.osee.ats.api.ev.IAtsWorkPackage;
import org.eclipse.osee.ats.api.workflow.IAtsAction;
import org.eclipse.osee.ats.ide.internal.Activator;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.util.AtsEditors;
import org.eclipse.osee.ats.ide.util.xviewer.column.XViewerAtsColumn;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateComposite;
import org.eclipse.osee.framework.ui.skynet.artifact.massEditor.MassArtifactEditor;
import org.eclipse.osee.framework.ui.skynet.cm.OseeCmEditor;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;

public abstract class AbstractWorkPackageRelatedColumnUI
extends XViewerAtsColumn
implements IMultiColumnEditProvider,
IXViewerValueColumn,
IAltLeftClickProvider {
    private final IAtsColumnId atsColumnId;

    public AbstractWorkPackageRelatedColumnUI(IAtsColumnId atsColumnId, String id, String name, int width, XViewerAlign align, boolean show, SortDataType sortDataType, boolean multiColumnEditable, String description) {
        super(id, name, width, align, show, sortDataType, multiColumnEditable, description);
        this.atsColumnId = atsColumnId;
    }

    public boolean handleAltLeftClick(TreeColumn treeColumn, TreeItem treeItem) {
        boolean modified = false;
        try {
            if (treeItem.getData() instanceof Artifact) {
                Artifact selectedArt = AtsApiService.get().getQueryServiceIde().getArtifact(treeItem);
                AbstractWorkflowArtifact useAwa = null;
                if (selectedArt instanceof IAtsAction && AtsApiService.get().getWorkItemService().getTeams((Object)selectedArt).size() == 1) {
                    useAwa = (AbstractWorkflowArtifact)AtsApiService.get().getWorkItemService().getFirstTeam((Object)selectedArt).getStoreObject();
                } else if (selectedArt instanceof AbstractWorkflowArtifact) {
                    useAwa = (AbstractWorkflowArtifact)selectedArt;
                }
                if (useAwa != null) {
                    this.openSelectedWorkPackages(Arrays.asList(useAwa));
                }
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
        return modified;
    }

    public void handleColumnMultiEdit(TreeColumn treeColumn, Collection<TreeItem> treeItems) {
        try {
            HashSet<AbstractWorkflowArtifact> awas = new HashSet<AbstractWorkflowArtifact>();
            for (TreeItem item : treeItems) {
                if (!(item.getData() instanceof AbstractWorkflowArtifact)) continue;
                AbstractWorkflowArtifact art = (AbstractWorkflowArtifact)((Object)item.getData());
                awas.add(art);
            }
            if (awas.isEmpty()) {
                AWorkbench.popup((String)"No Work Items Selected");
            } else {
                this.openSelectedWorkPackages(awas);
            }
        }
        catch (OseeCoreException ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (Throwable)ex);
        }
    }

    private void openSelectedWorkPackages(Collection<AbstractWorkflowArtifact> awas) {
        ArrayList<ArtifactId> ids = new ArrayList<ArtifactId>();
        for (AbstractWorkflowArtifact awa : awas) {
            IAtsWorkPackage workPkg = AtsApiService.get().getEarnedValueService().getWorkPackage((IAtsWorkItem)awa);
            if (workPkg == null || ids.contains(workPkg.getStoreObject())) continue;
            ids.add(ArtifactId.valueOf((Long)workPkg.getId()));
        }
        if (ids.isEmpty()) {
            AWorkbench.popup((String)"No Work Packages set for selected Work Items");
        } else if (ids.size() == 1) {
            AtsEditors.openArtifact(ArtifactQuery.getArtifactFromId((ArtifactId)((ArtifactId)ids.iterator().next()), (BranchId)AtsApiService.get().getAtsBranch()), OseeCmEditor.ArtifactEditor);
        } else {
            List artifacts = ArtifactQuery.getArtifactListFrom(ids, (BranchId)AtsApiService.get().getAtsBranch());
            ArtifactQuery.getArtifactListFrom(ids, (BranchId)AtsApiService.get().getAtsBranch());
            MassArtifactEditor.editArtifacts((String)"Edit Work Packages", (Collection)artifacts, (XNavigateComposite.TableLoadOption[])new XNavigateComposite.TableLoadOption[0]);
        }
    }

    public String getColumnText(Object element, XViewerColumn column, int columnIndex) {
        String result = "";
        if (element instanceof IAtsObject) {
            result = AtsApiService.get().getColumnService().getColumn(this.atsColumnId).getColumnText((IAtsObject)element);
        }
        return result;
    }
}

