/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions;

import java.util.HashMap;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.data.AtsAttributeTypes;
import org.eclipse.osee.ats.api.review.IAtsPeerToPeerReview;
import org.eclipse.osee.ats.api.review.ReviewDefectItem;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.skynet.widgets.dialog.EntryDialog;
import org.eclipse.osee.framework.ui.swt.ImageManager;

public class ValidatePeerDefectsAction
extends Action {
    public ValidatePeerDefectsAction() {
        this("Validate Peer Review by ID(s)");
    }

    public ValidatePeerDefectsAction(String name) {
        super(name);
        this.setToolTipText(this.getText());
    }

    public void run() {
        EntryDialog ed = new EntryDialog(this.getText(), "Enter Peer Review Id(s) (comma delimited");
        if (ed.open() == 0) {
            XResultData rd = new XResultData();
            rd.log(String.valueOf(this.getText()) + "\n\n");
            String idsStr = ed.getEntry();
            List workItems = AtsApiService.get().getQueryService().getWorkItemsByIds(idsStr);
            for (IAtsWorkItem workItem : workItems) {
                if (workItem.isPeerReview()) {
                    this.validateReviewDefects(workItem, rd);
                    continue;
                }
                rd.logf("WorkItem not Peer Review %s", new Object[]{workItem.toStringWithId()});
            }
            XResultDataUI.report((XResultData)rd, (String)this.getText());
        }
    }

    private void validateReviewDefects(IAtsWorkItem workItem, XResultData rd) {
        Artifact art = ArtifactQuery.reloadArtifactFromId((ArtifactId)workItem.getArtifactId(), (BranchId)AtsApiService.get().getAtsBranch());
        IAtsPeerToPeerReview review = (IAtsPeerToPeerReview)AtsApiService.get().getWorkItemService().getReview((ArtifactToken)art);
        HashMap<String, Attribute> guids = new HashMap<String, Attribute>();
        HashMap<Long, Attribute> ids = new HashMap<Long, Attribute>();
        for (Attribute attr : art.getAttributes((AttributeTypeId)AtsAttributeTypes.ReviewDefect)) {
            String xml = (String)attr.getValue();
            ReviewDefectItem item = AtsApiService.get().getReviewService().getDefectItem(xml, review);
            if (guids.keySet().contains(item.getGuid())) {
                rd.errorf("Duplicate guid %s on attr id %s and attr id %s\n", new Object[]{item.getGuid(), ((Attribute)guids.get(item.getGuid())).getIdString(), attr.getIdString()});
            } else {
                guids.put(item.getGuid(), attr);
            }
            if (ids.keySet().contains(item.getId())) {
                rd.errorf("Duplicate id %s on attr id %s and attr id %s\n", new Object[]{item.getId(), ((Attribute)ids.get(item.getId())).getIdString(), attr.getIdString()});
                continue;
            }
            ids.put(item.getId(), attr);
        }
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((OseeImage)AtsImage.PEER_REVIEW);
    }
}

