/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions;

import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osee.ats.api.util.AtsUtil;
import org.eclipse.osee.ats.ide.actions.AbstractAtsAction;
import org.eclipse.osee.ats.ide.actions.IDirtyReportable;
import org.eclipse.osee.framework.jdk.core.result.XResultData;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.ui.skynet.FrameworkImage;
import org.eclipse.osee.framework.ui.skynet.results.XResultDataUI;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;

public class DirtyReportAction
extends AbstractAtsAction {
    private final IDirtyReportable reportable;

    public DirtyReportAction(IDirtyReportable reportable) {
        super("Show Artifact Dirty Report");
        this.reportable = reportable;
        this.setToolTipText("Show what attribute or relation making editor dirty.");
    }

    @Override
    public void runWithException() {
        XResultData rd = new XResultData();
        rd.log("WorkflowEditor Dirty Report\n-----------------------------------------------\n");
        this.reportable.isDirtyResult(rd);
        if (AtsUtil.isInTest()) {
            throw new OseeStateException("Dirty Report", new Object[]{rd.isSuccess() ? "Not Dirty" : "Dirty -> " + rd.toString()});
        }
        rd.log("\n-----------------------------------------------");
        if (rd.isSuccess()) {
            rd.log("Editor is Not Dirty");
        } else {
            rd.error("Editor is Dirty");
        }
        XResultDataUI.report((XResultData)rd, (String)("Dirty Report - " + (rd.isSuccess() ? "Not Dirty" : "Dirty")));
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((KeyedImage)FrameworkImage.DIRTY);
    }
}

