/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ats.ide.actions;

import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.osee.ats.api.IAtsWorkItem;
import org.eclipse.osee.ats.api.util.AtsImage;
import org.eclipse.osee.ats.api.workdef.IAtsStateDefinition;
import org.eclipse.osee.ats.api.workflow.note.NoteType;
import org.eclipse.osee.ats.ide.actions.AbstractAtsAction;
import org.eclipse.osee.ats.ide.actions.wizard.NewNoteWizard;
import org.eclipse.osee.ats.ide.internal.AtsApiService;
import org.eclipse.osee.ats.ide.workflow.AbstractWorkflowArtifact;
import org.eclipse.osee.framework.core.enums.OseeImage;
import org.eclipse.osee.framework.ui.skynet.widgets.XList;
import org.eclipse.osee.framework.ui.swt.IDirtiableEditor;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.ui.PlatformUI;

public class AddNoteAction
extends AbstractAtsAction {
    private final AbstractWorkflowArtifact sma;
    private final IDirtiableEditor dirtiable;
    private boolean emulate = false;
    private String selectedState;
    private NoteType noteType;
    private String noteText;

    public AddNoteAction(AbstractWorkflowArtifact sma, IDirtiableEditor dirtiable) {
        this.sma = sma;
        this.dirtiable = dirtiable;
        this.setText("Add Note");
        this.setToolTipText(this.getText());
    }

    @Override
    public void runWithException() {
        boolean result;
        ArrayList<String> artifactNames = new ArrayList<String>();
        HashMap<String, String> selectedToStateName = new HashMap<String, String>();
        artifactNames.add("Whole \"" + this.sma.getArtifactTypeName() + "\"");
        for (IAtsStateDefinition stateDefinition : AtsApiService.get().getWorkDefinitionService().getStatesOrderedByOrdinal(this.sma.getWorkDefinition())) {
            String displayName = "\"" + stateDefinition.getName() + "\" State";
            artifactNames.add(displayName);
            selectedToStateName.put(displayName, stateDefinition.getName());
        }
        if (this.emulate ? !(result = this.performEmulate()) : !(result = this.performUi(artifactNames))) {
            return;
        }
        String state = "";
        if (!this.selectedState.startsWith(String.valueOf(this.sma.getName()) + " - ")) {
            state = (String)selectedToStateName.get(this.selectedState);
        }
        AtsApiService.get().getWorkItemService().getNotes((IAtsWorkItem)this.sma).addNote(this.noteType, state, this.noteText, AtsApiService.get().getUserService().getCurrentUser());
        this.dirtiable.onDirtied();
    }

    private boolean performEmulate() {
        this.selectedState = "Endorse";
        this.noteType = NoteType.Comment;
        this.noteText = "this is the comment";
        return true;
    }

    private boolean performUi(ArrayList<String> artifactNames) {
        NewNoteWizard noteWizard = new NewNoteWizard(artifactNames);
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IWizard)noteWizard);
        dialog.create();
        if (dialog.open() == 0) {
            this.selectedState = ((XList.XListItem)noteWizard.mainPage.artifactList.getSelected().iterator().next()).getName();
            this.noteType = NoteType.getType((String)((XList.XListItem)noteWizard.mainPage.typeList.getSelected().iterator().next()).getName());
            this.noteText = noteWizard.mainPage.noteText.get();
            return true;
        }
        return false;
    }

    public ImageDescriptor getImageDescriptor() {
        return ImageManager.getImageDescriptor((OseeImage)AtsImage.NEW_NOTE);
    }

    public void setEmulateUi(boolean emulate) {
        this.emulate = emulate;
    }
}

