/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.viewers.data;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public abstract class DataItem {
    private DataItem parentItem;
    private final Map<Object, DataItem> childrenMap;

    public DataItem(DataItem parentItem) {
        this.parentItem = parentItem;
        this.childrenMap = new HashMap<Object, DataItem>();
    }

    public void addChild(Object key, DataItem child) {
        this.childrenMap.put(key, child);
        child.setParent(this);
    }

    public void removeChild(DataItem child) {
        this.childrenMap.remove(child.getKey());
        child.setParent(null);
        child.dispose();
    }

    public DataItem[] getChildren() {
        Collection<DataItem> collection = this.childrenMap.values();
        return collection.toArray(new DataItem[collection.size()]);
    }

    public boolean hasChildren() {
        return this.childrenMap.size() > 0;
    }

    public void setParent(DataItem parent) {
        this.parentItem = parent;
    }

    public DataItem getParent() {
        return this.parentItem;
    }

    public void dispose() {
        if (this.hasChildren()) {
            DataItem[] dataItemArray = this.getChildren();
            int n = dataItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                DataItem item = dataItemArray[n2];
                item.dispose();
                ++n2;
            }
        }
    }

    public abstract Object getData();

    public abstract Object getKey();

    public boolean hasItem(Object key) {
        return this.childrenMap.containsKey(key);
    }

    public DataItem getChild(Object key) {
        return this.childrenMap.get(key);
    }
}

