/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.panels;

import java.net.URI;
import java.util.logging.Level;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.framework.ui.swt.FontManager;
import org.eclipse.osee.framework.ui.swt.Widgets;
import org.eclipse.osee.ote.ui.define.internal.Activator;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;

public class PreviewPanel
extends Composite {
    private static final String PREVIEW_DEFAULT_TITLE = "Preview Not Available";
    private Composite stackedComposite;
    private StackLayout stackLayout;
    private Composite defaultComposite;
    private Browser browser;

    public PreviewPanel(Composite parent, int style) {
        super(parent, style);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        this.setLayoutData(new GridData(4, 4, true, true));
        this.createControl(this);
    }

    private void createControl(Composite parent) {
        this.stackedComposite = new Composite(parent, 2048);
        this.stackLayout = new StackLayout();
        this.stackLayout.marginWidth = 0;
        this.stackLayout.marginHeight = 0;
        this.stackedComposite.setLayout((Layout)this.stackLayout);
        this.stackedComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.stackedComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (Widgets.isAccessible((Widget)PreviewPanel.this.browser)) {
                    PreviewPanel.this.browser.dispose();
                }
            }
        });
        this.createBrowserArea(this.stackedComposite);
        this.createPreviewNotAllowed(this.stackedComposite);
    }

    private void createBrowserArea(Composite parent) {
        this.browser = new Browser(parent, 0x1000800);
        this.browser.setLayoutData((Object)new GridData(1808));
        this.browser.setBackground(Displays.getSystemColor((int)5));
    }

    private void createPreviewNotAllowed(Composite parent) {
        this.defaultComposite = new Composite(parent, 2048);
        this.defaultComposite.setLayout((Layout)new GridLayout());
        this.defaultComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.defaultComposite.setBackground(Displays.getSystemColor((int)29));
        Label label = new Label(this.defaultComposite, 0);
        label.setFont(FontManager.getFont((String)"Courier New", (int)10, (int)1));
        label.setForeground(Displays.getSystemColor((int)4));
        label.setLayoutData((Object)new GridData(0x1000000, 0x1000000, true, true));
        label.setText(PREVIEW_DEFAULT_TITLE);
        label.setBackground(Displays.getSystemColor((int)29));
    }

    private Control getControl(PanelEnum panelId) {
        Composite control = this.defaultComposite;
        if (panelId.equals((Object)PanelEnum.BROWSER)) {
            control = this.browser;
        }
        return control;
    }

    public void setDisplay(PanelEnum panelId) {
        Control control;
        this.stackLayout.topControl = control = this.getControl(panelId);
        this.stackedComposite.layout();
        this.stackedComposite.getParent().layout();
        this.getParent().layout();
        this.getParent().getParent().layout();
    }

    public void updatePreview(PanelEnum panelId, URI uri) {
        try {
            if (panelId.equals((Object)PanelEnum.BROWSER)) {
                this.browser.setUrl(uri.toURL().toString());
            }
        }
        catch (Exception ex) {
            OseeLog.logf(Activator.class, (Level)Level.SEVERE, (Throwable)ex, (String)"Error Updating Preview [%s]", (Object[])new Object[]{panelId});
        }
    }

    public static enum PanelEnum {
        DEFAULT,
        BROWSER;

    }
}

