/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.jobs;

import java.util.Arrays;
import java.util.HashSet;
import java.util.logging.Level;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.swt.ImageManager;
import org.eclipse.osee.framework.ui.swt.KeyedImage;
import org.eclipse.osee.ote.define.artifacts.ArtifactTestRunOperator;
import org.eclipse.osee.ote.ui.define.OteDefineImage;
import org.eclipse.osee.ote.ui.define.dialogs.CommitDialog;
import org.eclipse.osee.ote.ui.define.dialogs.OverrideInvalidScriptRevisions;
import org.eclipse.osee.ote.ui.define.internal.Activator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.progress.UIJob;

class CommitJobDialog
extends UIJob {
    private static final Image CHILD_BRANCH_IMAGE = ImageManager.getImage((KeyedImage)OteDefineImage.CHILD_BRANCH);
    private static String JOB_NAME = "Commit Test Run";
    private String message;
    private Object[] items;
    private final Artifact[] allItems;
    private final Artifact[] preSelected;
    private final Artifact[] unselectable;
    private final boolean isOverrideAllowed;

    public CommitJobDialog(Artifact[] allitems, Artifact[] preSelected, boolean isOverrideAllowed) {
        this(allitems, preSelected, null, isOverrideAllowed);
    }

    public CommitJobDialog(Artifact[] allitems, Artifact[] preSelected, Artifact[] unselectable, boolean isOverrideAllowed) {
        super(JOB_NAME);
        this.allItems = allitems;
        this.preSelected = preSelected;
        this.unselectable = unselectable;
        this.setUser(false);
        this.setPriority(30);
        if (unselectable == null) {
            unselectable = new Artifact[]{};
        }
        this.isOverrideAllowed = isOverrideAllowed;
        this.message = null;
        this.items = null;
    }

    public String getMessage() {
        return this.message;
    }

    public Object[] getSelected() {
        return this.items;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        int result;
        IStatus toReturn = Status.CANCEL_STATUS;
        monitor.setTaskName(this.getName());
        Shell shell = AWorkbench.getActiveShell();
        CommitDialog dialog = new CommitDialog(shell, CommitColumnEnum.toStringArray(), new TestRunTableLabelProvider());
        dialog.setBlockOnOpen(true);
        dialog.setInput(this.allItems);
        dialog.setUnSelectable(this.unselectable);
        dialog.setSelected(this.preSelected);
        if (this.isOverrideAllowed) {
            dialog.setOverrideHandler(new OverrideInvalidScriptRevisions());
        }
        if ((result = dialog.open()) == 0) {
            this.message = dialog.getComments();
            this.items = dialog.getSelectedResources();
            toReturn = Status.OK_STATUS;
        }
        return toReturn;
    }

    private static enum CommitColumnEnum {
        Branch,
        Name,
        Id,
        Outfile;


        public static String[] toStringArray() {
            CommitColumnEnum[] cols = CommitColumnEnum.values();
            String[] toReturn = new String[cols.length];
            int index = 0;
            while (index < cols.length) {
                toReturn[index] = cols[index].name();
                ++index;
            }
            return toReturn;
        }
    }

    private final class TestRunTableLabelProvider
    extends BaseLabelProvider
    implements ITableLabelProvider {
        private final HashSet<Object> unselectableItems = new HashSet();
        private final int DUMMY_COLUMNS = 1;

        public TestRunTableLabelProvider() {
            if (CommitJobDialog.this.unselectable != null) {
                this.unselectableItems.addAll(Arrays.asList(CommitJobDialog.this.unselectable));
            }
        }

        public Image getColumnImage(Object element, int columnIndex) {
            Image toReturn = null;
            if (columnIndex >= 1) {
                CommitColumnEnum column = CommitColumnEnum.values()[columnIndex - 1];
                switch (column) {
                    case Branch: {
                        toReturn = CHILD_BRANCH_IMAGE;
                        break;
                    }
                }
            }
            return toReturn;
        }

        public String getColumnText(Object element, int columnIndex) {
            Artifact artifact;
            String toReturn = "";
            if (columnIndex >= 1 && element instanceof Artifact && !(artifact = (Artifact)element).isDeleted()) {
                CommitColumnEnum column = CommitColumnEnum.values()[columnIndex - 1];
                switch (column) {
                    case Branch: {
                        toReturn = artifact.getBranchToken().getName();
                        break;
                    }
                    case Id: {
                        try {
                            toReturn = new ArtifactTestRunOperator(artifact).getChecksum();
                        }
                        catch (Exception ex) {
                            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Error getting Checksum", (Throwable)ex);
                        }
                        break;
                    }
                    case Name: {
                        toReturn = artifact.getName();
                        break;
                    }
                    case Outfile: {
                        try {
                            toReturn = new ArtifactTestRunOperator(artifact).getOutfileAttribute().getDisplayableString();
                        }
                        catch (Exception ex) {
                            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)"Error getting Outfile", (Throwable)ex);
                        }
                        break;
                    }
                }
            }
            return toReturn;
        }
    }
}

