/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.ote.ui.define.importer;

import java.net.URI;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.osee.framework.core.data.BranchToken;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.osee.ote.define.jobs.FindCommitableJob;
import org.eclipse.osee.ote.define.jobs.OutfileToArtifactJob;
import org.eclipse.osee.ote.ui.define.jobs.CommitTestRunJob;
import org.eclipse.osee.ote.ui.define.jobs.ReportErrorsJob;
import org.eclipse.osee.ote.ui.define.utilities.CommitConfiguration;
import org.eclipse.swt.widgets.Shell;

public class ImportOutfileUIOperation {
    private final URI[] fileSystemObjects;
    private final BranchToken selectedBranch;

    public ImportOutfileUIOperation(BranchToken selectedBranch, URI ... fileSystemObjects) {
        this.fileSystemObjects = fileSystemObjects;
        this.selectedBranch = selectedBranch;
    }

    public boolean execute() {
        boolean toReturn = true;
        if (this.fileSystemObjects.length > 0) {
            this.launchImportJob();
        } else {
            toReturn = false;
            Shell shell = AWorkbench.getActiveShell();
            MessageDialog.openInformation((Shell)shell, (String)"Information", (String)"There were no resources currently selected for import.");
        }
        return toReturn;
    }

    private void launchImportJob() {
        OutfileToArtifactJob convertJob = new OutfileToArtifactJob(this.selectedBranch, this.fileSystemObjects);
        convertJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (ImportOutfileUIOperation.this.wasJobSuccessful(event)) {
                    OutfileToArtifactJob job = (OutfileToArtifactJob)event.getJob();
                    Object[] itemsWithError = job.getUnparseableFiles();
                    Artifact[] artifacts = job.getResults();
                    if (itemsWithError.length > 0) {
                        ImportOutfileUIOperation.this.reportFilesWithErrors(itemsWithError, artifacts);
                    } else {
                        ImportOutfileUIOperation.this.launchFindCommitableJob(artifacts);
                    }
                }
            }
        });
        convertJob.schedule();
    }

    private void launchCommitJob(final FindCommitableJob job) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                CommitTestRunJob newJob = new CommitTestRunJob(job.getAll(), job.getCommitAllowed(), job.getCommitNotAllowed(), CommitConfiguration.isCommitOverrideAllowed());
                newJob.schedule();
            }
        });
    }

    private void launchFindCommitableJob(Artifact[] artifacts) {
        FindCommitableJob commitableJob = new FindCommitableJob(artifacts);
        commitableJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                if (ImportOutfileUIOperation.this.wasJobSuccessful(event)) {
                    FindCommitableJob job = (FindCommitableJob)event.getJob();
                    ImportOutfileUIOperation.this.launchCommitJob(job);
                }
            }
        });
        commitableJob.schedule();
    }

    private void reportFilesWithErrors(Object[] items, final Artifact[] artifacts) {
        String title = "Outfile Import Error";
        String message = "The following file(s) had errors during the parsing operation: ";
        JobChangeAdapter listener = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                ImportOutfileUIOperation.this.launchFindCommitableJob(artifacts);
            }
        };
        ReportErrorsJob.openError(title, message, (IJobChangeListener)listener, items);
    }

    private boolean wasJobSuccessful(IJobChangeEvent event) {
        IStatus status = event.getResult();
        return status.equals(Status.OK_STATUS) || status.equals(0);
    }
}

