/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.ProjectSelectionDialog;
import org.eclipse.jdt.internal.debug.ui.actions.RuntimeClasspathAction;
import org.eclipse.jdt.internal.debug.ui.launcher.IClasspathViewer;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.viewers.IStructuredSelection;

public class AddProjectAction
extends RuntimeClasspathAction {
    public AddProjectAction(IClasspathViewer viewer) {
        super(ActionMessages.AddProjectAction_Add_Project_1, viewer);
    }

    public void run() {
        List<IJavaProject> projects = this.getPossibleAdditions();
        ProjectSelectionDialog dialog = new ProjectSelectionDialog(this.getShell(), projects);
        dialog.setTitle(ActionMessages.AddProjectAction_Project_Selection_2);
        MultiStatus status = new MultiStatus(JDIDebugUIPlugin.getUniqueIdentifier(), 150, "One or more exceptions occurred while adding projects.", null);
        if (dialog.open() == 0) {
            Object[] selections = dialog.getResult();
            ArrayList<IJavaProject> additions = new ArrayList<IJavaProject>(selections.length);
            try {
                Object[] objectArray = selections;
                int n = selections.length;
                int n2 = 0;
                while (n2 < n) {
                    Object selection = objectArray[n2];
                    IJavaProject jp = (IJavaProject)selection;
                    if (dialog.isAddRequiredProjects()) {
                        this.collectRequiredProjects(jp, additions);
                    } else {
                        additions.add(jp);
                    }
                    ++n2;
                }
            }
            catch (JavaModelException e) {
                status.add(e.getStatus());
            }
            ArrayList<IRuntimeClasspathEntry> runtimeEntries = new ArrayList<IRuntimeClasspathEntry>(additions.size());
            for (IJavaProject jp : additions) {
                runtimeEntries.add(JavaRuntime.newProjectRuntimeClasspathEntry((IJavaProject)jp));
                if (!dialog.isAddExportedEntries()) continue;
                try {
                    this.collectExportedEntries(jp, runtimeEntries);
                }
                catch (CoreException e) {
                    status.add(e.getStatus());
                }
            }
            IRuntimeClasspathEntry[] entries = runtimeEntries.toArray(new IRuntimeClasspathEntry[runtimeEntries.size()]);
            this.getViewer().addEntries(entries);
        }
        if (!status.isOK()) {
            JDIDebugUIPlugin.statusDialog((IStatus)status);
        }
    }

    @Override
    protected boolean updateSelection(IStructuredSelection selection) {
        return this.getViewer().updateSelection(this.getActionType(), selection) && !this.getPossibleAdditions().isEmpty();
    }

    @Override
    protected int getActionType() {
        return 1;
    }

    protected List<IJavaProject> getPossibleAdditions() {
        IJavaProject[] projects;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            projects = JavaCore.create((IWorkspaceRoot)root).getJavaProjects();
        }
        catch (JavaModelException e) {
            JDIDebugUIPlugin.log(e);
            projects = new IJavaProject[]{};
        }
        ArrayList<IJavaProject> remaining = new ArrayList<IJavaProject>();
        IJavaProject[] iJavaProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IJavaProject project = iJavaProjectArray[n2];
            remaining.add(project);
            ++n2;
        }
        ArrayList<IJavaProject> alreadySelected = new ArrayList<IJavaProject>();
        IRuntimeClasspathEntry[] iRuntimeClasspathEntryArray = this.getViewer().getEntries();
        int n3 = iRuntimeClasspathEntryArray.length;
        n = 0;
        while (n < n3) {
            IRuntimeClasspathEntry entry = iRuntimeClasspathEntryArray[n];
            if (entry.getType() == 1) {
                IResource res = root.findMember(entry.getPath());
                IJavaProject jp = (IJavaProject)JavaCore.create((IResource)res);
                alreadySelected.add(jp);
            }
            ++n;
        }
        remaining.removeAll(alreadySelected);
        return remaining;
    }

    protected void collectRequiredProjects(IJavaProject proj, List<IJavaProject> res) throws JavaModelException {
        if (!res.contains(proj)) {
            res.add(proj);
            IJavaModel model = proj.getJavaModel();
            IClasspathEntry[] iClasspathEntryArray = proj.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (n2 < n) {
                IJavaProject ref;
                IClasspathEntry curr = iClasspathEntryArray[n2];
                if (curr.getEntryKind() == 2 && (ref = model.getJavaProject(curr.getPath().segment(0))).exists()) {
                    this.collectRequiredProjects(ref, res);
                }
                ++n2;
            }
        }
    }

    protected void collectExportedEntries(IJavaProject proj, List<IRuntimeClasspathEntry> runtimeEntries) throws CoreException {
        IClasspathEntry[] iClasspathEntryArray = proj.getRawClasspath();
        int n = iClasspathEntryArray.length;
        int n2 = 0;
        while (n2 < n) {
            IClasspathEntry entry = iClasspathEntryArray[n2];
            if (entry.isExported()) {
                IRuntimeClasspathEntry rte = null;
                switch (entry.getEntryKind()) {
                    case 5: {
                        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)entry.getPath(), (IJavaProject)proj);
                        int kind = 0;
                        switch (container.getKind()) {
                            case 1: {
                                kind = 3;
                                break;
                            }
                            case 2: {
                                kind = 2;
                                break;
                            }
                            case 3: {
                                kind = 1;
                            }
                        }
                        rte = JavaRuntime.newRuntimeContainerClasspathEntry((IPath)entry.getPath(), (int)kind, (IJavaProject)proj);
                        break;
                    }
                    case 1: {
                        rte = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)entry.getPath());
                        rte.setSourceAttachmentPath(entry.getSourceAttachmentPath());
                        rte.setSourceAttachmentRootPath(entry.getSourceAttachmentRootPath());
                        break;
                    }
                    case 2: {
                        IJavaProject jp;
                        String name = entry.getPath().segment(0);
                        IProject p = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
                        if (!p.exists() || !(jp = JavaCore.create((IProject)p)).exists()) break;
                        rte = JavaRuntime.newProjectRuntimeClasspathEntry((IJavaProject)jp);
                        break;
                    }
                    case 4: {
                        rte = JavaRuntime.newVariableRuntimeClasspathEntry((IPath)entry.getPath());
                        break;
                    }
                }
                if (rte != null && !runtimeEntries.contains(rte)) {
                    runtimeEntries.add(rte);
                }
            }
            ++n2;
        }
    }
}

