/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.plugin.widgets;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.ExtensionPoints;
import org.eclipse.osee.framework.ui.plugin.internal.UiPluginConstants;
import org.eclipse.osee.framework.ui.plugin.widgets.IPropertyStoreBasedControl;
import org.osgi.framework.Bundle;

public class PropertyStoreControlContributions {
    private PropertyStoreControlContributions() {
    }

    public static List<IPropertyStoreBasedControl> getContributions(String viewIdToMatch) {
        ArrayList<IPropertyStoreBasedControl> toReturn = new ArrayList<IPropertyStoreBasedControl>();
        List elements = ExtensionPoints.getExtensionElements((String)"org.eclipse.osee.framework.ui.plugin.PropertyStoreControl", (String)"PropertyStoreControl");
        for (IConfigurationElement element : elements) {
            String bundleName;
            String className = element.getAttribute("classname");
            String viewId = element.getAttribute("viewId");
            if (viewIdToMatch == null || !viewIdToMatch.equals(viewId) || !Strings.isValid((String)(bundleName = element.getContributor().getName())) || !Strings.isValid((String)className)) continue;
            try {
                Object object;
                Bundle bundle = Platform.getBundle((String)bundleName);
                Class taskClass = bundle.loadClass(className);
                try {
                    Method getInstance = taskClass.getMethod("getInstance", new Class[0]);
                    object = getInstance.invoke(null, new Object[0]);
                }
                catch (Exception exception) {
                    object = taskClass.newInstance();
                }
                toReturn.add((IPropertyStoreBasedControl)object);
            }
            catch (Exception ex) {
                OseeLog.logf(UiPluginConstants.class, (Level)Level.SEVERE, (Throwable)ex, (String)"Unable to Load: [%s - %s]", (Object[])new Object[]{bundleName, className});
            }
        }
        return toReturn;
    }
}

