/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.framework.ui.plugin.views.property;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.osee.framework.ui.plugin.views.property.AbstractPropertySource;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;

public class CompositePropertySource
extends AbstractPropertySource {
    private List<AbstractPropertySource> sources;

    public CompositePropertySource() {
    }

    public CompositePropertySource(IPropertySource ... sources) {
        if (sources != null) {
            IPropertySource[] iPropertySourceArray = sources;
            int n = sources.length;
            int n2 = 0;
            while (n2 < n) {
                IPropertySource source = iPropertySourceArray[n2];
                this.add(source);
                ++n2;
            }
        }
    }

    public void add(IPropertySource propertySource) {
        if (propertySource instanceof AbstractPropertySource) {
            if (this.sources == null) {
                this.sources = new ArrayList<AbstractPropertySource>();
            }
            this.sources.add((AbstractPropertySource)propertySource);
        }
    }

    @Override
    protected void addPropertyDescriptors(List<IPropertyDescriptor> list) {
        if (this.sources != null) {
            for (AbstractPropertySource propertySource : this.sources) {
                propertySource.addPropertyDescriptors(list);
            }
        }
    }

    public Object getPropertyValue(Object id) {
        if (this.sources != null) {
            for (AbstractPropertySource propertySource : this.sources) {
                Object result = propertySource.getPropertyValue(id);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public boolean isPropertyResettable(Object id) {
        if (this.sources != null) {
            for (AbstractPropertySource propertySource : this.sources) {
                if (!propertySource.isPropertyResettable(id)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPropertySet(Object id) {
        if (this.sources != null) {
            for (AbstractPropertySource propertySource : this.sources) {
                if (!propertySource.isPropertySet(id)) continue;
                return true;
            }
        }
        return false;
    }

    public void resetPropertyValue(Object id) {
        if (this.sources != null) {
            for (AbstractPropertySource propertySource : this.sources) {
                propertySource.resetPropertyValue(id);
            }
        }
    }

    public void setPropertyValue(Object id, Object value) {
        if (this.sources != null) {
            for (AbstractPropertySource propertySource : this.sources) {
                propertySource.setPropertyValue(id, value);
            }
        }
    }
}

