/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability.report;

import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.osee.define.ide.traceability.ArtifactOperations;
import org.eclipse.osee.define.ide.traceability.RequirementTraceabilityData;
import org.eclipse.osee.define.ide.traceability.report.ISimpleTable;
import org.eclipse.osee.framework.jdk.core.type.HashCollectionSet;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;

public class StpTestToCsciTable
implements ISimpleTable {
    private final RequirementTraceabilityData source;

    public StpTestToCsciTable(RequirementTraceabilityData source) {
        this.source = source;
    }

    @Override
    public String getWorksheetName() {
        return "STP - Test to CSCI Requirements Traceability";
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getHeader() {
        StringBuilder builder = new StringBuilder();
        builder.append("<Column ss:StyleID=\"s38\" ss:AutoFitWidth=\"0\" ss:Width=\"55.5\"/>");
        builder.append("<Column ss:StyleID=\"s38\" ss:AutoFitWidth=\"0\" ss:Width=\"88.5\"/>");
        builder.append("<Column ss:StyleID=\"s38\" ss:AutoFitWidth=\"0\" ss:Width=\"114\"/>");
        builder.append("<Column ss:StyleID=\"s38\" ss:AutoFitWidth=\"0\" ss:Width=\"99.75\"/>");
        builder.append("<Column ss:StyleID=\"s38\" ss:AutoFitWidth=\"0\" ss:Width=\"105\"/>");
        builder.append("<Row ss:Height=\"13.5\">");
        builder.append("<Cell ss:MergeAcross=\"4\" ss:StyleID=\"s31\"><Data ss:Type=\"String\">Table X.X: Test to CSCI Requirements Traceability</Data></Cell>");
        builder.append("</Row>");
        builder.append("<Row ss:Height=\"14.25\">");
        builder.append("<Cell ss:MergeDown=\"1\" ss:StyleID=\"s25\"><Data ss:Type=\"String\">Test</Data></Cell>");
        builder.append("<Cell ss:MergeAcross=\"1\" ss:StyleID=\"s25\"><Data ss:Type=\"String\">CSCI Requirement</Data></Cell>");
        builder.append("<Cell ss:MergeDown=\"1\" ss:StyleID=\"s25\"><Data ss:Type=\"String\">Qual Method</Data></Cell>");
        builder.append("<Cell ss:MergeDown=\"1\" ss:StyleID=\"s25\"><Data ss:Type=\"String\">Qual Facility</Data></Cell>");
        builder.append("</Row>");
        builder.append("<Row ss:Height=\"14.25\">");
        builder.append("<Cell ss:Index=\"2\" ss:StyleID=\"s29\"><Data ss:Type=\"String\">Paragraph #</Data></Cell>");
        builder.append("<Cell ss:StyleID=\"s29\"><Data ss:Type=\"String\">Paragraph Title</Data></Cell>");
        builder.append("</Row>");
        return builder.toString();
    }

    @Override
    public String getHeaderStyles() {
        StringBuilder builder = new StringBuilder();
        builder.append("<Styles><Style ss:ID=\"Default\" ss:Name=\"Normal\"><Alignment ss:Vertical=\"Bottom\"/>");
        builder.append("<Borders/><Font/><Interior/><NumberFormat/><Protection/></Style>");
        builder.append("<Style ss:ID=\"s25\"><Alignment ss:Horizontal=\"Center\" ss:Vertical=\"Bottom\"/>");
        builder.append("<Borders><Border ss:Position=\"Bottom\" ss:LineStyle=\"Continuous\" ss:Weight=\"3\"/>");
        builder.append("<Border ss:Position=\"Left\" ss:LineStyle=\"Continuous\" ss:Weight=\"3\"/>");
        builder.append("<Border ss:Position=\"Right\" ss:LineStyle=\"Continuous\" ss:Weight=\"3\"/>");
        builder.append("<Border ss:Position=\"Top\" ss:LineStyle=\"Continuous\" ss:Weight=\"3\"/>");
        builder.append("</Borders><Font x:Family=\"Swiss\" ss:Bold=\"1\"/></Style>");
        builder.append("<Style ss:ID=\"s29\">");
        builder.append("<Alignment ss:Horizontal=\"Center\" ss:Vertical=\"Bottom\"/>");
        builder.append("<Borders><Border ss:Position=\"Bottom\" ss:LineStyle=\"Continuous\" ss:Weight=\"3\"/>");
        builder.append("<Border ss:Position=\"Left\" ss:LineStyle=\"Continuous\" ss:Weight=\"3\"/>");
        builder.append("<Border ss:Position=\"Right\" ss:LineStyle=\"Continuous\" ss:Weight=\"3\"/>");
        builder.append("<Border ss:Position=\"Top\" ss:LineStyle=\"Continuous\" ss:Weight=\"3\"/>");
        builder.append("</Borders><Font x:Family=\"Swiss\" ss:Bold=\"1\"/>");
        builder.append("</Style><Style ss:ID=\"s31\">");
        builder.append("<Alignment ss:Horizontal=\"Center\" ss:Vertical=\"Bottom\"/>");
        builder.append("<Borders><Border ss:Position=\"Bottom\" ss:LineStyle=\"Continuous\" ss:Weight=\"3\"/>");
        builder.append("</Borders>");
        builder.append("<Font x:Family=\"Swiss\" ss:Bold=\"1\"/>");
        builder.append("</Style>");
        builder.append("<Style ss:ID=\"s38\"><Alignment ss:Vertical=\"Bottom\" ss:WrapText=\"1\"/></Style>");
        builder.append("</Styles>");
        return builder.toString();
    }

    @Override
    public void generateBody(ExcelXmlWriter sheetWriter) throws Exception {
        Collection<Artifact> directRequirements = this.source.getDirectSwRequirements();
        HashCollectionSet<String, Artifact> partitionMap = ArtifactOperations.sortByPartition(directRequirements);
        for (String partition : new TreeSet(partitionMap.keySet())) {
            List<Artifact> artifacts = partitionMap.getValues((Object)partition);
            artifacts = ArtifactOperations.sortByParagraphNumbers((Collection<Artifact>)artifacts);
            for (Artifact artifact : artifacts) {
                this.processRow(sheetWriter, partition, artifact);
            }
        }
    }

    private void processRow(ExcelXmlWriter sheetWriter, String partition, Artifact artifact) throws Exception {
        ArtifactOperations operator = new ArtifactOperations(artifact);
        String paragraphTitle = operator.getName();
        String paragraphNumber = operator.getParagraphNumber();
        String qualMethod = operator.getQualificationMethod();
        String qualFacility = operator.getQualificationFacility();
        sheetWriter.writeRow(new Object[]{partition, paragraphNumber, paragraphTitle, qualMethod, qualFacility});
    }
}

