/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability.report;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.osee.ats.api.user.AtsUser;

public class RequirementStatus
implements Comparable<RequirementStatus> {
    private final String requirementName;
    private final String legacyId;
    private final String swEnhancement;
    private final StringBuilder partitionStatuses;
    private final List<Integer> percents;
    private final HashSet<AtsUser> testPocs;

    public RequirementStatus(String requirementName, String legacyId, String swEnhancement) {
        this.requirementName = requirementName;
        this.legacyId = legacyId;
        this.swEnhancement = swEnhancement;
        this.partitionStatuses = new StringBuilder();
        this.percents = new LinkedList<Integer>();
        this.testPocs = new HashSet();
    }

    public void addPartitionStatus(int percentComplete, String partition, String resolution) {
        if (partition == null) {
            System.out.println("Missing partiton for " + this.requirementName + ": " + this.legacyId);
            partition = "";
        }
        this.partitionStatuses.append(partition);
        this.partitionStatuses.append(':');
        this.partitionStatuses.append(resolution);
        this.partitionStatuses.append(' ');
        this.percents.add(percentComplete);
    }

    public String getPartitionStatuses() {
        return this.partitionStatuses.toString();
    }

    public int getRolledupPercentComplete() {
        int total = 0;
        for (int percent : this.percents) {
            total += percent;
        }
        return total / this.percents.size();
    }

    public void setTestPocs(Collection<AtsUser> poc) {
        this.testPocs.addAll(poc);
    }

    public HashSet<AtsUser> getTestPocs() {
        return this.testPocs;
    }

    public String getLegacyId() {
        return this.legacyId;
    }

    @Override
    public int compareTo(RequirementStatus status) {
        if (this.legacyId == null) {
            return -1;
        }
        return this.legacyId.compareTo(status.legacyId);
    }

    public String getSwEnhancement() {
        return this.swEnhancement;
    }
}

