/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability.operations;

import java.io.InputStream;
import java.net.URI;
import java.nio.CharBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.osee.define.ide.internal.Activator;
import org.eclipse.osee.define.ide.traceability.ITraceUnitResourceLocator;
import org.eclipse.osee.define.ide.traceability.ResourceIdentifier;
import org.eclipse.osee.define.ide.traceability.TraceUnitExtensionManager;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.type.HashCollectionSet;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.search.ArtifactQuery;
import org.eclipse.osee.framework.ui.plugin.util.AWorkbench;
import org.eclipse.osee.framework.ui.skynet.artifact.editor.ArtifactEditorInput;
import org.eclipse.osee.framework.ui.swt.Displays;
import org.eclipse.ui.IEditorInput;

public final class FindTraceUnitFromResource {
    private FindTraceUnitFromResource() {
    }

    private static HashCollectionSet<ArtifactTypeToken, ResourceIdentifier> toIdentifiers(IResource ... resources) {
        HashCollectionSet returnCollection = new HashCollectionSet(HashSet::new);
        if (resources != null && resources.length > 0) {
            try {
                Set<ITraceUnitResourceLocator> locators = TraceUnitExtensionManager.getInstance().getAllTraceUnitLocators();
                IResource[] iResourceArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource resource = iResourceArray[n2];
                    FindTraceUnitFromResource.resourceToId((HashCollectionSet<ArtifactTypeToken, ResourceIdentifier>)returnCollection, resource, locators);
                    ++n2;
                }
            }
            catch (Exception ex) {
                OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
            }
        }
        return returnCollection;
    }

    private static void resourceToId(HashCollectionSet<ArtifactTypeToken, ResourceIdentifier> idStore, IResource resource, Set<ITraceUnitResourceLocator> locators) {
        try {
            IFileStore fileStore = EFS.getStore((URI)resource.getLocationURI());
            for (ITraceUnitResourceLocator locator : locators) {
                if (!locator.isValidFile(fileStore)) continue;
                InputStream inputStream = null;
                try {
                    try {
                        inputStream = fileStore.openInputStream(0, (IProgressMonitor)new NullProgressMonitor());
                        CharBuffer buffer = Lib.inputStreamToCharBuffer((InputStream)inputStream);
                        ResourceIdentifier identifier = locator.getIdentifier(fileStore, buffer);
                        ArtifactTypeToken traceType = locator.getTraceUnitType(identifier.getName(), buffer);
                        idStore.put((Object)traceType, (Object)identifier);
                    }
                    catch (Exception ex) {
                        OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                        if (inputStream == null) continue;
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception) {}
                        continue;
                    }
                }
                catch (Throwable throwable) {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                if (inputStream == null) continue;
                try {
                    inputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    public static void search(BranchId branch, IResource ... resources) {
        HashCollectionSet<ArtifactTypeToken, ResourceIdentifier> typeAndIds = FindTraceUnitFromResource.toIdentifiers(resources);
        if (!typeAndIds.isEmpty()) {
            HashSet<Artifact> artifacts = new HashSet<Artifact>();
            for (ArtifactTypeToken artifactType : typeAndIds.keySet()) {
                Collection items = typeAndIds.getValues((Object)artifactType);
                if (items == null) continue;
                for (ResourceIdentifier resource : items) {
                    try {
                        artifacts.addAll(ArtifactQuery.getArtifactListFromTypeAndName((ArtifactTypeId)artifactType, (String)resource.getName(), (BranchId)branch));
                    }
                    catch (OseeCoreException ex) {
                        OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                    }
                }
            }
            if (!artifacts.isEmpty()) {
                FindTraceUnitFromResource.openArtifacts(artifacts);
            } else {
                AWorkbench.popup((String)"Find Trace Unit from Resource", (String)String.format("Unable to find trace for: %s on branch [%s]", Arrays.deepToString(resources), branch));
            }
        } else {
            AWorkbench.popup((String)"Find Trace Unit from Resource", (String)String.format("Unable to find trace handler for: %s", Arrays.deepToString(resources)));
        }
    }

    private static void openArtifacts(final Collection<Artifact> artifacts) {
        Displays.ensureInDisplayThread((Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    for (Artifact artifact : artifacts) {
                        AWorkbench.getActivePage().openEditor((IEditorInput)new ArtifactEditorInput(artifact), "org.eclipse.osee.framework.ui.skynet.artifact.editor.ArtifactEditor", true);
                    }
                }
                catch (Exception ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
        });
    }
}

