/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability.jobs;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.osee.define.ide.internal.Activator;
import org.eclipse.osee.define.ide.traceability.operations.FindTraceUnitFromResource;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.plugin.core.util.IExceptionableRunnable;
import org.eclipse.osee.framework.plugin.core.util.Jobs;
import org.eclipse.osee.framework.ui.skynet.branch.BranchSelectionDialog;
import org.eclipse.ui.progress.UIJob;

public class FindTraceUnitJob
extends Job {
    private final IResource[] resources;

    public FindTraceUnitJob(String name, IResource ... resources) {
        super(name);
        this.resources = resources != null ? resources : new IResource[0];
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.resources != null && this.resources.length > 0) {
            FetchBranchJob job = new FetchBranchJob(this.getName());
            Jobs.startJob((Job)job, (boolean)true, (IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    FetchBranchJob fetcherJob = (FetchBranchJob)event.getJob();
                    final BranchId branch = fetcherJob.getSelectedBranch();
                    if (branch != null) {
                        IExceptionableRunnable runnable = new IExceptionableRunnable(){

                            public IStatus run(IProgressMonitor monitor) throws Exception {
                                FindTraceUnitFromResource.search(branch, FindTraceUnitJob.this.resources);
                                return Status.OK_STATUS;
                            }
                        };
                        Jobs.runInJob((String)FindTraceUnitJob.this.getName(), (IExceptionableRunnable)runnable, Activator.class, (String)"org.eclipse.osee.define.ide");
                    }
                }
            });
        }
        return Status.OK_STATUS;
    }

    private static final class FetchBranchJob
    extends UIJob {
        private BranchId branch;

        public FetchBranchJob(String name) {
            super(name);
        }

        public IStatus runInUIThread(IProgressMonitor monitor) {
            this.branch = BranchSelectionDialog.getBranchFromUser();
            return Status.OK_STATUS;
        }

        public BranchId getSelectedBranch() {
            return this.branch;
        }
    }
}

