/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability.importer;

import java.net.URI;
import java.util.logging.Level;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.osee.define.ide.internal.Activator;
import org.eclipse.osee.define.ide.traceability.importer.ImportTraceUnitPage;
import org.eclipse.osee.define.ide.traceability.operations.ImportTraceUnitsOperation;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.operation.IOperation;
import org.eclipse.osee.framework.core.operation.Operations;
import org.eclipse.osee.framework.logging.OseeLevel;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ImportTraceUnitWizard
extends Wizard
implements IImportWizard {
    private ImportTraceUnitPage page;
    private IStructuredSelection selection;

    public ImportTraceUnitWizard() {
        this.setWindowTitle("Import Trace Units Wizard");
    }

    public boolean performFinish() {
        try {
            BranchId importToBranch = this.page.getSelectedBranch();
            boolean isRecursive = this.page.isFolderRecursionAllowed();
            boolean isPersistChanges = this.page.isArtifactPersistanceAllowed();
            Iterable<URI> sources = this.page.getSourceURI();
            String[] traceUnitHandlerIds = this.page.getTraceUnitHandlerIds();
            boolean fileWithMultiPaths = this.page.isFileContainingMultiplePaths();
            boolean addGuidToSourceFile = this.page.isAddGuidToSourceFileAllowed();
            boolean includeImpd = this.page.isImpdIncluded();
            ImportTraceUnitsOperation op = new ImportTraceUnitsOperation("Import Trace Units", importToBranch, sources, isRecursive, isPersistChanges, fileWithMultiPaths, addGuidToSourceFile, includeImpd, traceUnitHandlerIds);
            Operations.executeAsJob((IOperation)op, (boolean)true);
            this.page.saveWidgetValues();
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)OseeLevel.SEVERE_POPUP, (String)"Import Trace Unit Error", (Throwable)ex);
        }
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }

    public void addPages() {
        this.page = new ImportTraceUnitPage(this.selection);
        this.addPage((IWizardPage)this.page);
    }
}

