/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.define.ide.internal.Activator;
import org.eclipse.osee.define.ide.traceability.TraceUnitExtensionManager;
import org.eclipse.osee.define.ide.traceability.TraceabilityProviderOperation;
import org.eclipse.osee.define.ide.traceability.data.RequirementData;
import org.eclipse.osee.define.ide.traceability.data.TraceMark;
import org.eclipse.osee.framework.core.data.ArtifactId;
import org.eclipse.osee.framework.core.data.ArtifactTypeToken;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.core.data.OseeData;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.jdk.core.type.CountingMap;
import org.eclipse.osee.framework.jdk.core.type.HashCollectionSet;
import org.eclipse.osee.framework.jdk.core.type.OseeArgumentException;
import org.eclipse.osee.framework.jdk.core.type.OseeCoreException;
import org.eclipse.osee.framework.jdk.core.type.OseeStateException;
import org.eclipse.osee.framework.jdk.core.type.Pair;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.CharBackedInputStream;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ISheetWriter;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.plugin.core.util.AIFile;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.artifact.Attribute;
import org.eclipse.osee.framework.skynet.core.word.WordUtil;
import org.eclipse.osee.ote.define.artifacts.ArtifactTestRunOperator;
import org.eclipse.swt.program.Program;

public class ScriptTraceabilityOperation
extends TraceabilityProviderOperation {
    private static final Pattern filePattern = Pattern.compile(".*\\.(java|ada|ads|adb|c|h)");
    private static final Matcher structuredRequirementMatcher = Pattern.compile("\\[?(\\{[^\\}]+\\})(.*)").matcher("");
    private static final Matcher embeddedVolumeMatcher = Pattern.compile("\\{\\d+ (.*)\\}[ .]*").matcher("");
    private static final Matcher stripTrailingReqNameMatcher = Pattern.compile("(\\}|\\])(.*)").matcher("");
    private static final Matcher nonWordMatcher = Pattern.compile("[^A-Z_0-9]").matcher("");
    private static final Matcher subsystemMatcher = Pattern.compile("(\\w*)\\.ss").matcher("");
    private static final Matcher gitSubsystemMatcher = Pattern.compile("\\w*\\.ofp\\\\(\\w*)").matcher("");
    private final Collection<TraceUnitExtensionManager.TraceHandler> traceHandlers;
    private final File file;
    private final RequirementData requirementData;
    private final ArrayList<String> noTraceabilityFiles = new ArrayList(200);
    private final CountingMap<Artifact> reqsTraceCounts = new CountingMap();
    private final HashCollectionSet<Artifact, String> requirementToCodeUnitsMap = new HashCollectionSet(LinkedHashSet::new);
    private final HashSet<String> codeUnits = new HashSet();
    private final CharBackedInputStream charBak;
    private final ISheetWriter excelWriter;
    private int pathPrefixLength;
    private final boolean writeOutResults;
    private final boolean isGitBased;
    private final boolean includeImpd;

    private ScriptTraceabilityOperation(RequirementData requirementData, File file, boolean writeOutResults, Collection<TraceUnitExtensionManager.TraceHandler> traceHandlers, boolean isGitBased, boolean includeImpd) throws IOException {
        super("Importing Traceability", "org.eclipse.osee.define.ide");
        this.file = file;
        this.requirementData = requirementData;
        this.writeOutResults = writeOutResults;
        this.traceHandlers = traceHandlers;
        this.isGitBased = isGitBased;
        this.includeImpd = includeImpd;
        this.charBak = new CharBackedInputStream();
        this.excelWriter = new ExcelXmlWriter(this.charBak.getWriter());
    }

    public ScriptTraceabilityOperation(File file, BranchId branch, boolean writeOutResults, Collection<TraceUnitExtensionManager.TraceHandler> traceHandlers, boolean isGitBased, ArtifactId viewId, boolean includeImpd) throws IOException {
        this(new RequirementData(branch, viewId), file, writeOutResults, traceHandlers, isGitBased, includeImpd);
    }

    public ScriptTraceabilityOperation(File file, BranchId branch, boolean writeOutResults, Collection<? extends ArtifactTypeToken> types, boolean withInheritance, Collection<TraceUnitExtensionManager.TraceHandler> traceHandlers, boolean isGitBased, ArtifactId viewId, boolean includeImpd) throws IOException {
        this(new RequirementData(branch, types, withInheritance, viewId), file, writeOutResults, traceHandlers, isGitBased, includeImpd);
    }

    protected void doWork(IProgressMonitor monitor) throws Exception {
        monitor.worked(1);
        this.requirementData.initialize(monitor);
        if (this.writeOutResults) {
            this.excelWriter.startSheet("srs <--> code units", 6);
            this.excelWriter.writeRow(new Object[]{"Req in DB", "Subsystem", "Code Unit", "Requirement Name", "Requirement Trace Mark in Code", "Trace Mark Match"});
        }
        if (this.file.isFile()) {
            for (String path : Lib.readListFromFile((File)this.file, (boolean)true)) {
                monitor.subTask(path);
                this.handleDirectory(new File(path), this.traceHandlers);
                ScriptTraceabilityOperation.checkForCancelledStatus((IProgressMonitor)monitor);
            }
        } else if (this.file.isDirectory()) {
            this.handleDirectory(this.file, this.traceHandlers);
        } else {
            throw new OseeStateException("Invalid path [%s]", new Object[]{this.file.getCanonicalPath()});
        }
        ScriptTraceabilityOperation.checkForCancelledStatus((IProgressMonitor)monitor);
        if (this.writeOutResults) {
            this.excelWriter.endSheet();
            this.writeNoTraceFilesSheet();
            this.writeTraceCountsSheet();
            this.excelWriter.endWorkbook();
            IFile iFile = OseeData.getIFile((String)"CodeUnit_To_SRS_Trace.xml");
            AIFile.writeToFile((IFile)iFile, (InputStream)this.charBak);
            Program.launch((String)iFile.getLocation().toOSString());
        }
    }

    private void handleDirectory(File directory, Collection<TraceUnitExtensionManager.TraceHandler> traceHandlers) throws IOException {
        if (directory == null || directory.getParentFile() == null) {
            throw new OseeArgumentException("The path [%s] is invalid.", new Object[]{directory});
        }
        this.pathPrefixLength = directory.getParentFile().getAbsolutePath().length();
        for (File sourceFile : Lib.recursivelyListFiles((File)directory, (Pattern)filePattern)) {
            CharBuffer buffer = Lib.fileToCharBuffer((File)sourceFile);
            LinkedList<TraceMark> tracemarks = new LinkedList<TraceMark>();
            for (TraceUnitExtensionManager.TraceHandler handler : traceHandlers) {
                handler.getParser().setupTraceMatcher(this.includeImpd);
                handler.getParser().setupCommentTraceMatcher(this.includeImpd);
                Collection<TraceMark> marks = handler.getParser().getTraceMarks(buffer);
                tracemarks.addAll(marks);
            }
            int matchCount = 0;
            String relativePath = sourceFile.getPath().substring(this.pathPrefixLength);
            this.codeUnits.add(relativePath);
            for (TraceMark traceMark : tracemarks) {
                this.handelReqTrace(relativePath, traceMark, sourceFile);
                ++matchCount;
            }
            if (matchCount != 0) continue;
            this.noTraceabilityFiles.add(relativePath);
        }
    }

    private void writeNoTraceFilesSheet() throws IOException {
        this.excelWriter.startSheet("no match files", 1);
        for (String path : this.noTraceabilityFiles) {
            this.excelWriter.writeRow(new Object[]{path});
        }
        this.excelWriter.endSheet();
    }

    private void writeTraceCountsSheet() throws IOException {
        this.excelWriter.startSheet("trace counts", 4);
        this.excelWriter.writeRow(new Object[]{"SRS Requirement from Database", "Trace Count", "Partitions", "Artifact Type"});
        this.excelWriter.writeRow(new Object[]{"% requirement coverage", null, "=1-COUNTIF(C2,&quot;0&quot;)/COUNTA(C2)", null});
        for (Artifact artifact : this.requirementData.getDirectRequirements()) {
            this.excelWriter.writeRow(new Object[]{artifact.getName(), String.valueOf(this.reqsTraceCounts.get((Object)artifact)), Collections.toString((String)",", (Iterable)artifact.getAttributesToStringList((AttributeTypeId)CoreAttributeTypes.Partition)), artifact.getArtifactType()});
        }
        this.excelWriter.endSheet();
    }

    private Pair<String, String> getStructuredRequirement(String requirementMark) {
        Pair toReturn = null;
        structuredRequirementMatcher.reset(requirementMark);
        if (structuredRequirementMatcher.matches()) {
            String primary = structuredRequirementMatcher.group(1);
            String secondary = structuredRequirementMatcher.group(2);
            if (Strings.isValid((String)primary)) {
                toReturn = new Pair((Object)primary, (Object)secondary);
            }
        }
        return toReturn;
    }

    public String getCanonicalRequirementName(String requirementMark) {
        String canonicalReqReference = requirementMark;
        if (Strings.isValid((String)requirementMark)) {
            String trail;
            canonicalReqReference = requirementMark.toUpperCase();
            embeddedVolumeMatcher.reset(canonicalReqReference);
            if (embeddedVolumeMatcher.find()) {
                canonicalReqReference = embeddedVolumeMatcher.group(1);
            }
            stripTrailingReqNameMatcher.reset(canonicalReqReference);
            if (stripTrailingReqNameMatcher.find() && Strings.isValid((String)(trail = stripTrailingReqNameMatcher.group(2))) && !trail.startsWith(".")) {
                canonicalReqReference = canonicalReqReference.substring(0, stripTrailingReqNameMatcher.start(1) + 1);
            }
            nonWordMatcher.reset(canonicalReqReference);
            canonicalReqReference = nonWordMatcher.replaceAll("");
        }
        return canonicalReqReference;
    }

    private String getSubsystem(String source, Matcher matcher) {
        String subSystem = null;
        matcher.reset(source);
        if (matcher.find()) {
            subSystem = matcher.group(1);
            subSystem = subSystem.toUpperCase();
        } else {
            subSystem = "no valid subsystem found";
        }
        return subSystem;
    }

    private void handelReqTrace(String path, TraceMark traceMark, File sourceFile) throws IOException {
        String foundStr;
        Artifact reqArtifact = null;
        String subSystem = null;
        String textContent = null;
        boolean traceMatch = false;
        String string = subSystem = this.isGitBased ? this.getSubsystem(sourceFile.getPath(), gitSubsystemMatcher) : this.getSubsystem(sourceFile.getPath(), subsystemMatcher);
        if (traceMark.getTraceType().equals("Uses")) {
            foundStr = "invalid trace mark";
        } else {
            reqArtifact = this.requirementData.getRequirementFromTraceMark(traceMark.getRawTraceMark());
            if (reqArtifact == null) {
                Pair<String, String> structuredRequirement = this.getStructuredRequirement(traceMark.getRawTraceMark());
                if (structuredRequirement != null) {
                    reqArtifact = this.requirementData.getRequirementFromTraceMark((String)structuredRequirement.getFirst());
                    if (reqArtifact == null) {
                        foundStr = "no match in DB";
                    } else {
                        if (reqArtifact.getAttributeCount((AttributeTypeId)CoreAttributeTypes.WordTemplateContent) > 0) {
                            textContent = WordUtil.textOnly((String)((String)reqArtifact.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.WordTemplateContent, (Object)""))).toUpperCase();
                        } else {
                            List attributes = reqArtifact.getAttributes();
                            for (Attribute attribute : attributes) {
                                textContent = String.valueOf(textContent) + attribute.toString();
                            }
                        }
                        foundStr = textContent != null && (textContent.contains((CharSequence)structuredRequirement.getSecond()) || textContent.contains(this.getCanonicalRequirementName((String)structuredRequirement.getSecond()))) ? "req body match" : "req name match/element missing in body";
                    }
                } else {
                    foundStr = "no match in DB";
                }
            } else {
                foundStr = this.fullMatch(reqArtifact);
                List partitions = reqArtifact.getAttributesToStringList((AttributeTypeId)CoreAttributeTypes.Partition);
                if (partitions.contains(subSystem)) {
                    traceMatch = true;
                }
            }
        }
        String name = null;
        if (reqArtifact != null) {
            name = reqArtifact.getName();
            String inspection = this.getInspectionQual(reqArtifact);
            if (Strings.isValid((String)inspection)) {
                this.requirementToCodeUnitsMap.put((Object)reqArtifact, (Object)inspection);
                if (reqArtifact.getAttributeValues((AttributeTypeId)CoreAttributeTypes.QualificationMethod).contains("Test")) {
                    this.requirementToCodeUnitsMap.put((Object)reqArtifact, (Object)path);
                }
            } else {
                this.requirementToCodeUnitsMap.put((Object)reqArtifact, (Object)path);
            }
        }
        if (this.writeOutResults) {
            this.excelWriter.writeRow(new Object[]{foundStr, subSystem, path, name, traceMark, traceMatch});
        }
    }

    private String fullMatch(Artifact reqArtifact) {
        this.reqsTraceCounts.put((Object)reqArtifact);
        return "full match";
    }

    @Override
    public HashCollectionSet<Artifact, String> getRequirementToCodeUnitsMap() {
        return this.requirementToCodeUnitsMap;
    }

    public HashSet<String> getCodeUnits() {
        return this.codeUnits;
    }

    @Override
    public RequirementData getRequirementData() {
        return this.requirementData;
    }

    @Override
    public Collection<Artifact> getTestUnitArtifacts(Artifact requirement) {
        HashSet<Artifact> toReturn = new HashSet<Artifact>();
        Collection scriptNames = this.requirementToCodeUnitsMap.getValues((Object)requirement);
        if (scriptNames != null) {
            for (String script : scriptNames) {
                try {
                    Artifact testScript = ArtifactTestRunOperator.getTestScriptFetcher().getNewArtifact(requirement.getBranch());
                    testScript.setName(script);
                    toReturn.add(testScript);
                }
                catch (OseeCoreException ex) {
                    OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
                }
            }
        }
        return toReturn;
    }

    @Override
    public Artifact getTestUnitByName(String name) {
        return null;
    }
}

