/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.traceability;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osee.define.ide.internal.Activator;
import org.eclipse.osee.define.ide.traceability.TraceUnitExtensionManager;
import org.eclipse.osee.framework.core.data.BranchId;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.logging.OseeLog;
import org.eclipse.osee.framework.ui.plugin.util.DirectoryOrFileSelector;
import org.eclipse.osee.framework.ui.skynet.branch.BranchSelectComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.dialogs.WizardDataTransferPage;

public class ImportTraceabilityPage
extends WizardDataTransferPage {
    public static final String PAGE_NAME = "org.eclipse.osee.define.ide.wizardPage.importTraceabilityPage";
    private static final String TRACE_UNIT_HANDLER_GROUP = "Select trace unit parser";
    private static final String GIT_CODE_STRUCTURE_GROUP = "Select to use Git codebase";
    private static final String INCLUDE_IMPD_GROUP = "Include IMPD";
    private DirectoryOrFileSelector directoryFileSelector;
    private BranchSelectComposite branchSelectComposite;
    private final Map<Button, Boolean> traceUnitHandlers;
    private boolean isGitCodeStructure = false;
    private boolean includeImpd = false;
    private IResource currentResourceSelection;

    public ImportTraceabilityPage(IStructuredSelection selection) {
        super(PAGE_NAME);
        Object firstElement;
        this.setTitle("Import traceability into OSEE Define");
        this.setDescription("Import relations between artifacts");
        this.traceUnitHandlers = new HashMap<Button, Boolean>();
        if (selection != null && selection.size() == 1 && (firstElement = selection.getFirstElement()) instanceof IAdaptable) {
            this.currentResourceSelection = (IResource)((IAdaptable)firstElement).getAdapter(IResource.class);
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setSize(composite.computeSize(-1, -1));
        composite.setFont(parent.getFont());
        this.createSourceGroup(composite);
        this.createParserSelectArea(composite);
        this.createGitStructureCheckbox(composite);
        this.createIncludeImpdCheckbox(composite);
        this.restoreWidgetValues();
        this.updateWidgetEnablements();
        this.setPageComplete(this.determinePageCompletion());
        this.setControl((Control)composite);
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.determinePageCompletion());
    }

    protected boolean determinePageCompletion() {
        return super.determinePageCompletion() && this.preprocessInput(this.getImportFile());
    }

    protected void createSourceGroup(Composite parent) {
        this.directoryFileSelector = new DirectoryOrFileSelector(parent, 0, "Import Source", (Listener)this);
        if (this.currentResourceSelection == null) {
            this.directoryFileSelector.setDirectorySelected(true);
        } else {
            this.directoryFileSelector.setDirectorySelected(this.currentResourceSelection.getType() != 1);
            this.directoryFileSelector.setText(this.currentResourceSelection.getLocation().toString());
        }
        Group composite = new Group(parent, 0);
        composite.setText("Destination Branch");
        GridLayout gd = new GridLayout();
        composite.setLayout((Layout)gd);
        composite.setLayoutData((Object)new GridData(768));
        this.branchSelectComposite = new BranchSelectComposite((Composite)composite, 2048, false);
        this.setPageComplete(this.determinePageCompletion());
    }

    protected void createParserSelectArea(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setText(TRACE_UNIT_HANDLER_GROUP);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        try {
            for (TraceUnitExtensionManager.TraceHandler handler : TraceUnitExtensionManager.getInstance().getAllTraceHandlers()) {
                this.createTraceHandler((Composite)composite, handler.getName(), handler.getId());
            }
        }
        catch (Exception ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (Throwable)ex);
        }
    }

    private void createGitStructureCheckbox(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setText(GIT_CODE_STRUCTURE_GROUP);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        Button handlerButton = new Button((Composite)composite, 32);
        handlerButton.setText("Use Git Code Structure");
        handlerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object source = e.getSource();
                if (source instanceof Button) {
                    Button button = (Button)source;
                    ImportTraceabilityPage.this.isGitCodeStructure = button.getSelection();
                }
            }
        });
    }

    private void createIncludeImpdCheckbox(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setText(INCLUDE_IMPD_GROUP);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        Button handlerButton = new Button((Composite)composite, 32);
        handlerButton.setText(INCLUDE_IMPD_GROUP);
        handlerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object source = e.getSource();
                if (source instanceof Button) {
                    Button button = (Button)source;
                    ImportTraceabilityPage.this.includeImpd = button.getSelection();
                }
            }
        });
    }

    private void createTraceHandler(Composite parent, String text, String handlerId) {
        Button handlerButton = new Button(parent, 32);
        handlerButton.setText(text);
        handlerButton.setData((Object)handlerId);
        handlerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object source = e.getSource();
                if (source instanceof Button) {
                    Button button = (Button)source;
                    ImportTraceabilityPage.this.traceUnitHandlers.put(button, button.getSelection());
                }
                ImportTraceabilityPage.this.setPageComplete(ImportTraceabilityPage.this.determinePageCompletion());
            }
        });
        this.traceUnitHandlers.put(handlerButton, false);
    }

    public String[] getTraceUnitHandlerIds() {
        ArrayList<String> selectedIds = new ArrayList<String>();
        for (Button button : this.traceUnitHandlers.keySet()) {
            Boolean value = this.traceUnitHandlers.get(button);
            if (value == null || !value.booleanValue()) continue;
            selectedIds.add((String)button.getData());
        }
        return selectedIds.toArray(new String[selectedIds.size()]);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setErrorMessage(null);
        }
    }

    protected boolean validateSourceGroup() {
        return this.directoryFileSelector.validate((WizardDataTransferPage)this);
    }

    public File getImportFile() {
        return this.directoryFileSelector.getSingleSelection();
    }

    public BranchId getSelectedBranch() {
        return this.branchSelectComposite.getSelectedBranch();
    }

    public boolean isGitBased() {
        return this.isGitCodeStructure;
    }

    public boolean includeImpd() {
        return this.includeImpd;
    }

    protected boolean allowNewContainerName() {
        return false;
    }

    private boolean preprocessInput(final File file) {
        final StringBuilder errorMessage = new StringBuilder();
        try {
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) {
                    if (file != null) {
                        try {
                            int count = 0;
                            for (String path : Lib.readListFromFile((File)file, (boolean)true)) {
                                File toCheck = new File(path);
                                if (!toCheck.exists()) {
                                    ++count;
                                    errorMessage.append(String.format("\nPath does not exist: [%s]", path));
                                    continue;
                                }
                                if (toCheck.isDirectory()) continue;
                                ++count;
                                errorMessage.append(String.format("\nNot a directory: [%s]", path));
                            }
                            if (count > 0) {
                                errorMessage.insert(0, String.format("%d paths have errors:", count));
                            }
                        }
                        catch (IOException ex) {
                            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)Lib.exceptionToString((Exception)ex));
                        }
                    }
                }
            });
        }
        catch (InvocationTargetException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)Lib.exceptionToString((Exception)ex));
        }
        catch (InterruptedException ex) {
            OseeLog.log(Activator.class, (Level)Level.SEVERE, (String)Lib.exceptionToString((Exception)ex));
        }
        if (errorMessage.length() != 0) {
            this.setErrorMessage(errorMessage.toString());
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(null);
        return true;
    }
}

