/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osee.define.ide.blam.operation;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osee.define.ide.blam.operation.TestStatusEnum;
import org.eclipse.osee.framework.core.data.ArtifactTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeId;
import org.eclipse.osee.framework.core.data.AttributeTypeToken;
import org.eclipse.osee.framework.core.data.OseeData;
import org.eclipse.osee.framework.core.data.RelationTypeSide;
import org.eclipse.osee.framework.core.enums.CoreArtifactTypes;
import org.eclipse.osee.framework.core.enums.CoreAttributeTypes;
import org.eclipse.osee.framework.core.enums.CoreRelationTypes;
import org.eclipse.osee.framework.jdk.core.util.Collections;
import org.eclipse.osee.framework.jdk.core.util.Lib;
import org.eclipse.osee.framework.jdk.core.util.Strings;
import org.eclipse.osee.framework.jdk.core.util.io.CharBackedInputStream;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelColumn;
import org.eclipse.osee.framework.jdk.core.util.io.xml.ExcelXmlWriter;
import org.eclipse.osee.framework.plugin.core.util.AIFile;
import org.eclipse.osee.framework.skynet.core.artifact.Artifact;
import org.eclipse.osee.framework.skynet.core.relation.RelationManager;
import org.eclipse.osee.framework.skynet.core.utility.Artifacts;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavItemCat;
import org.eclipse.osee.framework.ui.plugin.xnavigate.XNavigateItem;
import org.eclipse.osee.framework.ui.skynet.blam.AbstractBlam;
import org.eclipse.osee.framework.ui.skynet.blam.VariableMap;
import org.eclipse.swt.program.Program;

public final class TestPlanComplianceReport
extends AbstractBlam {
    public static final String TEST_PLANS = "Test Plans";
    public static final String MAX_ENTRIES_PER_CELL = "Max Entries Per Cell";
    public static final String FONT_SIZE = "Font Size";
    private static final int DEFAULT_MAX = 25;
    private static final int DEFAULT_FONT_SIZE = 11;
    private static final String BLANK_SPACE = " ";
    private Collection<Artifact> inputArtifacts;
    private Collection<Artifact> testPlans;
    private boolean performFileWrite;
    private int maxRowsPerCell = 25;
    private int fontSize = 11;
    private CharBackedInputStream charBackedStream = null;
    private Writer defaultWriter = null;
    private ExcelXmlWriter excelWriter = null;

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor) throws Exception {
        this.charBackedStream = new CharBackedInputStream();
        this.runOperation(variableMap, monitor, this.charBackedStream.getWriter(), true);
    }

    public void runOperation(VariableMap variableMap, IProgressMonitor monitor, Writer writer, boolean performFileWrite) throws Exception {
        this.defaultWriter = writer;
        this.performFileWrite = performFileWrite;
        this.init(variableMap);
        for (Artifact input : this.inputArtifacts) {
            this.processArtifacts(input);
        }
        this.report();
    }

    private void processArtifacts(Artifact node) throws IOException {
        List children = node.getChildren();
        if (this.isTestPlan(node)) {
            String testPlan = this.getArtifactNameAndParagraph(node);
            List<String> perfSpecs = this.getRequirementsCellOutput(node, CoreRelationTypes.VerificationPlan_Requirement);
            List<String> pids = this.getRequirementsCellOutput(node, CoreRelationTypes.Validation_Requirement);
            List testProcedures = node.getRelatedArtifacts(CoreRelationTypes.Executes_TestProcedure);
            LinkedList testProcedureNames = Lists.newLinkedList((Iterable)Artifacts.getNames((Collection)testProcedures));
            TestStatusAndResults testStatusAndResults = this.calculateTestStatusAndResults(testProcedures);
            this.writeRow(testPlan, perfSpecs, pids, testProcedureNames, testStatusAndResults.testStatus, testStatusAndResults.testResults, testStatusAndResults.errors);
        } else {
            this.excelWriter.writeRow(new Object[]{node, BLANK_SPACE, BLANK_SPACE, "N/A (" + node.getArtifactTypeName() + ")", BLANK_SPACE, BLANK_SPACE, BLANK_SPACE});
        }
        for (Artifact child : children) {
            this.processArtifacts(child);
        }
    }

    private void writeRow(String testPlan, List<String> perfSpecs, List<String> pids, List<String> testProcNames, List<String> testProcStatuses, List<String> testResultNames, List<String> errors) throws IOException {
        LinkedList<List> allPartitions = new LinkedList<List>();
        allPartitions.add(Lists.partition(perfSpecs, (int)this.maxRowsPerCell));
        allPartitions.add(Lists.partition(pids, (int)this.maxRowsPerCell));
        allPartitions.add(Lists.partition(testProcNames, (int)this.maxRowsPerCell));
        allPartitions.add(Lists.partition(testProcStatuses, (int)this.maxRowsPerCell));
        allPartitions.add(Lists.partition(testResultNames, (int)this.maxRowsPerCell));
        allPartitions.add(Lists.partition(errors, (int)this.maxRowsPerCell));
        int max = 0;
        for (List list : allPartitions) {
            max = Math.max(max, list.size());
        }
        int i = 0;
        while (i < max) {
            this.excelWriter.writeCell((Object)testPlan);
            testPlan = BLANK_SPACE;
            int j = 0;
            while (j < allPartitions.size() - 1) {
                List list = (List)allPartitions.get(j);
                if (list.size() > i) {
                    this.excelWriter.writeCell((Object)Collections.toString((String)"\n", (Iterable)((Iterable)list.get(i))));
                } else {
                    this.excelWriter.writeCell((Object)BLANK_SPACE);
                }
                ++j;
            }
            List errorPartitions = (List)allPartitions.get(allPartitions.size() - 1);
            if (errorPartitions.size() > i) {
                this.excelWriter.setCellStyle(ExcelXmlWriter.STYLE.ERROR, 6);
                this.excelWriter.writeCell((Object)Collections.toString((String)"\n", (Iterable)((Iterable)errorPartitions.get(i))));
            } else {
                this.excelWriter.writeCell((Object)BLANK_SPACE);
            }
            this.excelWriter.endRow();
            ++i;
        }
    }

    private TestStatusAndResults calculateTestStatusAndResults(List<Artifact> testProcedures) {
        LinkedList<String> testProcStatus = new LinkedList<String>();
        LinkedList<String> testResultNames = new LinkedList<String>();
        LinkedList<String> errors = new LinkedList<String>();
        for (Artifact testProc : testProcedures) {
            String status = (String)testProc.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.TestProcedureStatus, (Object)BLANK_SPACE);
            List testResults = testProc.getRelatedArtifacts(CoreRelationTypes.ResultsData_TestResult);
            testProcStatus.add(status);
            TestStatusEnum enumStatus = TestStatusEnum.fromString(status);
            if (testResults.isEmpty()) {
                switch (enumStatus) {
                    case COMPLETED_PASSED_CODE: 
                    case COMPLETED_WITH_ISSUES_CODE: 
                    case COMPLETED_WITH_ISSUES_RESOLVED_CODE: {
                        errors.add("No test result files found...");
                        break;
                    }
                }
                continue;
            }
            if (enumStatus == TestStatusEnum.NOT_PERFORMED_CODE) {
                errors.add("Results with NOT_PERFORMED_CODE status");
            }
            for (Artifact testResult : testResults) {
                String extension = testResult.getSoleAttributeValueAsString((AttributeTypeToken)CoreAttributeTypes.Extension, "");
                testResultNames.add(String.valueOf(testResult.getName()) + (extension.equals("") ? extension : "." + extension.toLowerCase()));
            }
        }
        TestStatusAndResults toReturn = new TestStatusAndResults();
        toReturn.testResults = testResultNames;
        toReturn.testStatus = testProcStatus;
        toReturn.errors = errors;
        return toReturn;
    }

    private boolean isTestPlan(Artifact src) {
        return src.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.TestPlanElementMsWord});
    }

    private List<String> getRequirementsCellOutput(Artifact art, RelationTypeSide rts) {
        List<String> result = null;
        if (art.isOfType(new ArtifactTypeId[]{CoreArtifactTypes.TestPlanElementMsWord})) {
            result = this.getRequirementsAsString(art, rts);
        }
        return result;
    }

    private List<String> getRequirementsAsString(Artifact testPlan, RelationTypeSide rts) {
        List requirementArtifacts = testPlan.getRelatedArtifacts(rts);
        ArrayList<String> requirementNames = new ArrayList<String>();
        for (Artifact req : requirementArtifacts) {
            String paragraphNumber = (String)req.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, (Object)"");
            requirementNames.add(String.valueOf(paragraphNumber) + BLANK_SPACE + req.getName());
        }
        return requirementNames;
    }

    private String getArtifactNameAndParagraph(Artifact art) {
        return String.valueOf((String)art.getSoleAttributeValue((AttributeTypeId)CoreAttributeTypes.ParagraphNumber, (Object)"")) + BLANK_SPACE + art.getName();
    }

    private void report() throws IOException {
        this.excelWriter.endSheet();
        this.excelWriter.endWorkbook();
        if (this.performFileWrite) {
            IFile iFile = OseeData.getIFile((String)("TestPlanComplianceReport_" + Lib.getDateTimeString() + ".xml"));
            AIFile.writeToFile((IFile)iFile, (InputStream)this.charBackedStream);
            Program.launch((String)iFile.getLocation().toOSString());
        }
    }

    private void init(VariableMap variableMap) throws IOException {
        this.inputArtifacts = variableMap.getArtifacts(TEST_PLANS);
        String max = variableMap.getString(MAX_ENTRIES_PER_CELL);
        if (!Strings.isNumeric((String)max)) {
            this.log(new String[]{String.format("[%s] is not a valid number, using [%d] for max entries per cell", max, this.maxRowsPerCell)});
        } else {
            this.maxRowsPerCell = Integer.parseInt(max);
        }
        String font = variableMap.getString(FONT_SIZE);
        if (!Strings.isNumeric((String)font)) {
            this.log(new String[]{String.format("[%s] is not a valid number, using [%d] for font size", font, this.fontSize)});
        } else {
            this.fontSize = Integer.parseInt(font);
        }
        this.initReport();
        this.load();
    }

    private void initReport() throws IOException {
        this.excelWriter = new ExcelXmlWriter(this.defaultWriter, null, "\u00f8", this.fontSize);
        String[] columnHeaders = new String[]{"Test Plan & Paragraph", "Perf Spec Requirement(s)", "PIDS", "Test Procedure", "Test Status", "Test Result File", "Errors"};
        ExcelColumn[] columns = new ExcelColumn[columnHeaders.length];
        int i = 0;
        while (i < columnHeaders.length) {
            ExcelColumn newCol;
            String header = columnHeaders[i];
            columns[i] = newCol = ExcelColumn.newCol((String)header, (double)250.0, (String)"OseeWraped");
            ++i;
        }
        this.excelWriter.startSheet(this.getName(), columns);
    }

    private void load() {
        this.testPlans = new ArrayList<Artifact>();
        for (Artifact input : this.inputArtifacts) {
            this.testPlans.addAll(input.getDescendants());
        }
        RelationManager.getRelatedArtifacts(this.testPlans, (int)1, (RelationTypeSide[])new RelationTypeSide[]{CoreRelationTypes.VerificationPlan_Requirement});
        Set temp = RelationManager.getRelatedArtifacts(this.testPlans, (int)1, (RelationTypeSide[])new RelationTypeSide[]{CoreRelationTypes.Executes_TestProcedure});
        RelationManager.getRelatedArtifacts((Collection)temp, (int)1, (RelationTypeSide[])new RelationTypeSide[]{CoreRelationTypes.ResultsData_TestResult});
    }

    public String getXWidgetsXml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<xWidgets>");
        sb.append(String.format("<XWidget xwidgetType=\"XListDropViewer\" displayName=\"%s\" />", TEST_PLANS));
        sb.append(String.format("<XWidget xwidgetType=\"XText\" displayName=\"%s\" defaultValue=\"%d\"/>", MAX_ENTRIES_PER_CELL, 25));
        sb.append(String.format("<XWidget xwidgetType=\"XText\" displayName=\"%s\" defaultValue=\"%d\"/>", FONT_SIZE, 11));
        sb.append("</xWidgets>");
        return sb.toString();
    }

    public Collection<XNavItemCat> getCategories() {
        return Arrays.asList(XNavigateItem.REPORTS);
    }

    public String getName() {
        return "Test Plan Compliance Report";
    }

    private class TestStatusAndResults {
        List<String> testStatus;
        List<String> testResults;
        List<String> errors;

        private TestStatusAndResults() {
        }
    }
}

